<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<-------------ENGLISH TRANSLATION: KDROG0V------------------>
//<----------------------------------------------------------->

?>

<style>
/* Futuristic slim footer */
.futuristic-footer {
    background: rgba(26, 26, 46, 0.7);
    backdrop-filter: blur(15px);
    -webkit-backdrop-filter: blur(15px);
    border-radius: 12px;
    border: 1px solid rgba(0, 243, 255, 0.1);
    box-shadow: 
        0 0 20px rgba(0, 243, 255, 0.05),
        inset 0 1px 0 rgba(255, 255, 255, 0.05),
        0 2px 10px rgba(0, 0, 0, 0.2);
    padding: 1rem 1.5rem;
    margin: 1rem auto;
    max-width: 100%;
    position: relative;
    overflow: hidden;
}

.futuristic-footer::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, 
        transparent 0%,
        var(--cyber-blue) 50%,
        transparent 100%);
    opacity: 0.5;
}

.footer-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
    min-height: 40px;
}

.footer-text {
    color: var(--star-white);
    font-size: 0.85rem;
    font-weight: 400;
    margin: 0;
    opacity: 0.8;
}

.footer-developer {
    color: var(--cyber-blue);
    font-weight: 600;
}

.footer-year {
    color: var(--hologram-teal);
    font-weight: 500;
}

.telegram-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: rgba(0, 243, 255, 0.1);
    border: 1px solid rgba(0, 243, 255, 0.2);
    border-radius: 8px;
    padding: 0.4rem 1rem;
    color: var(--cyber-blue);
    text-decoration: none;
    font-weight: 600;
    font-size: 0.8rem;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.telegram-link:hover {
    transform: translateY(-1px);
    color: var(--hologram-teal);
    text-decoration: none;
    box-shadow: 
        0 4px 12px rgba(0, 243, 255, 0.2),
        0 0 0 1px rgba(255, 255, 255, 0.05);
    background: rgba(0, 243, 255, 0.15);
}

.telegram-link::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, 
        transparent, 
        rgba(255, 255, 255, 0.1), 
        transparent);
    transition: left 0.5s ease;
}

.telegram-link:hover::before {
    left: 100%;
}

.telegram-icon {
    font-size: 0.9rem;
}

/* Subtle glow effect */
.footer-glow {
    position: absolute;
    bottom: -20px;
    left: 50%;
    transform: translateX(-50%);
    width: 100px;
    height: 20px;
    background: radial-gradient(ellipse at center, 
        rgba(0, 243, 255, 0.1) 0%,
        transparent 70%);
    filter: blur(10px);
    z-index: -1;
    opacity: 0.3;
}

/* Even slimmer version for mobile */
@media (max-width: 768px) {
    .futuristic-footer {
        padding: 0.8rem 1rem;
        margin: 0.5rem;
        border-radius: 10px;
    }
    
    .footer-content {
        flex-direction: row;
        justify-content: space-between;
        gap: 0.8rem;
        min-height: 35px;
    }
    
    .footer-text {
        font-size: 0.75rem;
    }
    
    .telegram-link {
        padding: 0.3rem 0.8rem;
        font-size: 0.75rem;
        gap: 6px;
    }
    
    .telegram-icon {
        font-size: 0.8rem;
    }
}

@media (max-width: 480px) {
    .futuristic-footer {
        padding: 0.6rem 0.8rem;
    }
    
    .footer-content {
        flex-direction: column;
        text-align: center;
        gap: 0.5rem;
    }
    
    .footer-text {
        order: 2;
        font-size: 0.7rem;
    }
    
    .telegram-link {
        order: 1;
        width: auto;
        font-size: 0.7rem;
    }
}

/* Super slim version */
.futuristic-footer.slim {
    padding: 0.5rem 1rem;
    border-radius: 8px;
}

.futuristic-footer.slim .footer-content {
    min-height: 30px;
}

.futuristic-footer.slim .footer-text {
    font-size: 0.7rem;
}

.futuristic-footer.slim .telegram-link {
    padding: 0.2rem 0.7rem;
    font-size: 0.7rem;
}
</style>

<!--start overlay-->
<div class="overlay toggle-icon"></div>
<!--end overlay-->
<!--Start Back To Top Button--> 
<a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
<!--End Back To Top Button-->

<!-- Slim Futuristic Footer -->
<div class="futuristic-footer slim">
    <div class="footer-glow"></div>
    
    <div class="footer-content">
        <p class="footer-text">
            ADM - <span class="footer-developer">EONBRY</span> © 
            <span class="footer-year"><?php echo date("Y")?></span>
        </p>
        
        <a href="https://t.me/eonbry" target="_blank" class="telegram-link">
            <i class="fab fa-telegram telegram-icon"></i>
            Telegram
        </a>
    </div>
</div>

</div>
<!--end wrapper-->
<!-- Bootstrap JS -->
<script src="assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="assets/js/jquery.min.js"></script>
<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
<script src="assets/js/index3.js"></script>
<script>
    new PerfectScrollbar('.best-selling-products');
    new PerfectScrollbar('.recent-reviews');
    new PerfectScrollbar('.support-list');
</script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    $('#myTable').DataTable({
        order: [[0, 'desc']],
        "pageLength": 25
    });
    
    // Smooth hover effect for Telegram link
    $('.telegram-link').hover(
        function() {
            $(this).css({
                'transform': 'translateY(-2px)',
                'box-shadow': '0 4px 12px rgba(0, 243, 255, 0.25)'
            });
        },
        function() {
            $(this).css({
                'transform': 'translateY(0)',
                'box-shadow': 'none'
            });
        }
    );
    
    // Subtle glow effect on card hover
    $('.futuristic-footer').hover(
        function() {
            $(this).css({
                'box-shadow': '0 0 15px rgba(0, 243, 255, 0.1)',
                'border-color': 'rgba(0, 243, 255, 0.2)'
            });
        },
        function() {
            $(this).css({
                'box-shadow': '0 0 20px rgba(0, 243, 255, 0.05)',
                'border-color': 'rgba(0, 243, 255, 0.1)'
            });
        }
    );
});
</script>
<!--app JS-->
<script src="assets/js/app.js"></script>
</body>
</html>