<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/eonbry------------------>
//<-------------DEVELOPER: EMANUEL NASCIMENTO----------------->
//<-------------ENGLISH TRANSLATION: KDROG0V------------------>
//<----------------------------------------------------------->


ini_set('display_errors', 1);
error_reporting(E_ALL);

include(__DIR__ . '/functions.php'); 

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Main user (id = 1)
$log_check = $db->select('user', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? ($log_check[0]['username'] ?? null) : null;

// Session validation
if (empty($_SESSION['name']) || $_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit();
}

// Logout
if (isset($_REQUEST['logout'])) {
    session_unset();
    session_destroy();
    setcookie("auth", "", time() - 3600, "/");
    header("Location: index.php");
    exit();
}

// Timeout (15 minutes)
$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    session_start();
    header("Location: index.php");
    exit();
}
$_SESSION['LAST_ACTIVITY'] = time();

function sanitize($data) {
    $data = trim($data);
    $data = htmlspecialchars($data, ENT_QUOTES);
    return SQLite3::escapeString($data);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>ADOO IPTV | ADMIN PANEL</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="NL">

    <link rel="icon" type="image/x-icon" href="assets/images/log.png">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --deep-blue: #070b14;
            --sidebar-bg: #0a0f1a;
            --accent-blue: #3b82f6;
            --cyber-blue: #00f3ff;
            --hologram-teal: #0ea5e9;
            --star-white: #f8fafc;
            --glass-bg: rgba(30, 41, 59, 0.6);
            --glass-border: rgba(255, 255, 255, 0.05);
            --item-bg: rgba(255, 255, 255, 0.03);
            --text-main: #f8fafc;
            --text-muted: #64748b;
        }

        body {
            background-color: var(--deep-blue);
            background-image: radial-gradient(circle at 0% 0%, rgba(59, 130, 246, 0.05) 0%, transparent 50%);
            color: var(--text-main);
            font-family: 'Inter', sans-serif;
            margin: 0;
            overflow-x: hidden;
        }

        #wrapper {
            display: flex;
            width: 100%;
            transition: all 0.3s ease;
        }

        /* Sidebar */
        #sidebar-wrapper {
            min-width: 280px;
            max-width: 280px;
            min-height: 100vh;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--glass-border);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            padding: 20px;
            position: relative;
            overflow-y: auto;
        }

        #sidebar-wrapper.active {
            margin-left: -280px;
        }

        .sidebar-heading {
            padding: 20px 10px 40px 10px;
            text-align: center;
        }

        .sidebar-logo img {
            max-width: 160px;
            filter: drop-shadow(0 0 12px rgba(59, 130, 246, 0.2));
        }

        /* Menu Items as Boxes */
        .menu-container {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .menu-item {
            background: var(--item-bg);
            border: 1px solid var(--glass-border);
            border-radius: 16px;
            padding: 16px 20px;
            color: var(--text-muted);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            cursor: pointer;
        }

        .menu-item i {
            font-size: 1.2rem;
            color: var(--text-muted);
            transition: all 0.3s ease;
        }

        .menu-item span {
            font-weight: 600;
            font-size: 0.95rem;
            letter-spacing: 0.3px;
        }

        .menu-item:hover {
            background: rgba(59, 130, 246, 0.08);
            border-color: rgba(59, 130, 246, 0.3);
            color: var(--text-main);
            text-decoration: none;
            transform: translateX(5px);
        }

        .menu-item:hover i {
            color: var(--accent-blue);
            filter: drop-shadow(0 0 8px var(--accent-blue));
        }

        .menu-item.active {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.15), rgba(59, 130, 246, 0.05));
            border-color: var(--accent-blue);
            color: var(--text-main);
        }

        .menu-item.active i {
            color: var(--accent-blue);
        }

        /* Special button for footer */
        .menu-item-footer {
            background: linear-gradient(135deg, rgba(0, 243, 255, 0.1), rgba(30, 41, 59, 0.6));
            border: 1px solid rgba(0, 243, 255, 0.2);
            border-radius: 16px;
            padding: 16px 20px;
            color: var(--cyber-blue);
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            cursor: pointer;
        }

        .menu-item-footer i {
            font-size: 1.2rem;
            color: var(--cyber-blue);
            transition: all 0.3s ease;
        }

        .menu-item-footer span {
            font-weight: 600;
            font-size: 0.95rem;
            letter-spacing: 0.3px;
        }

        .menu-item-footer:hover {
            background: linear-gradient(135deg, rgba(0, 243, 255, 0.2), rgba(0, 243, 255, 0.1));
            border-color: var(--cyber-blue);
            color: var(--star-white);
            transform: translateX(5px);
            box-shadow: 0 0 15px rgba(0, 243, 255, 0.2);
        }

        .menu-item-footer:hover i {
            color: var(--star-white);
            filter: drop-shadow(0 0 10px var(--cyber-blue));
        }

        /* Modal to display footer1.php */
        .footer-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(7, 11, 20, 0.95);
            backdrop-filter: blur(10px);
            z-index: 9999;
            overflow-y: auto;
            animation: fadeIn 0.3s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .modal-content {
            background: rgba(10, 15, 26, 0.95);
            border: 1px solid var(--glass-border);
            border-radius: 20px;
            max-width: 800px;
            margin: 50px auto;
            padding: 0;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.5);
            position: relative;
        }

        .modal-header {
            padding: 25px 30px;
            border-bottom: 1px solid var(--glass-border);
            background: rgba(0, 243, 255, 0.05);
            border-radius: 20px 20px 0 0;
        }

        .modal-header h4 {
            color: var(--cyber-blue);
            font-weight: 700;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .modal-header h4 i {
            font-size: 1.4rem;
        }

        .modal-body {
            padding: 30px;
        }

        .modal-footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
            padding: 20px 30px;
            background: rgba(26, 26, 46, 0.7);
            border-top: 1px solid rgba(0, 243, 255, 0.1);
            border-radius: 0 0 20px 20px;
        }

        .modal-footer-text {
            color: var(--star-white);
            font-size: 0.9rem;
            font-weight: 400;
            margin: 0;
        }

        .modal-developer {
            color: var(--cyber-blue);
            font-weight: 600;
        }

        .modal-year {
            color: var(--hologram-teal);
            font-weight: 500;
        }

        .modal-telegram-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(0, 243, 255, 0.1);
            border: 1px solid rgba(0, 243, 255, 0.2);
            border-radius: 8px;
            padding: 0.5rem 1rem;
            color: var(--cyber-blue);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .modal-telegram-link:hover {
            background: rgba(0, 243, 255, 0.2);
            color: var(--star-white);
            text-decoration: none;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 243, 255, 0.3);
        }

        .close-modal {
            position: absolute;
            top: 25px;
            right: 30px;
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.2);
            color: #ef4444;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 1.2rem;
        }

        .close-modal:hover {
            background: #ef4444;
            color: white;
            transform: rotate(90deg);
        }

        .menu-label {
            font-size: 0.7rem;
            font-weight: 800;
            color: #334155;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            margin: 20px 0 10px 10px;
        }

        /* Page Content */
        #page-content-wrapper {
            width: 100%;
            flex: 1;
        }

        .ctnav {
            background: rgba(10, 15, 26, 0.8) !important;
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-bottom: 1px solid var(--glass-border);
            padding: 15px 30px;
        }

        #menu-toggle {
            background: var(--item-bg);
            border: 1px solid var(--glass-border);
            color: var(--text-main);
            width: 42px;
            height: 42px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: 0.2s;
            outline: none;
        }

        #menu-toggle:hover {
            background: rgba(59, 130, 246, 0.1);
            border-color: var(--accent-blue);
            color: var(--accent-blue);
        }

        .btn-logout {
            background: rgba(239, 68, 68, 0.05);
            border: 1px solid rgba(239, 68, 68, 0.1);
            color: #ef4444;
            border-radius: 12px;
            padding: 10px 22px;
            font-weight: 700;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: 0.3s;
        }

        .btn-logout:hover {
            background: #ef4444;
            color: white;
            text-decoration: none;
            box-shadow: 0 0 20px rgba(239, 68, 68, 0.2);
        }

        #pageMessages {
            position: fixed;
            top: 25px;
            left: 50%;
            transform: translateX(-50%);
            width: 400px;
            z-index: 9999;
        }

        @media (max-width: 768px) {
            #sidebar-wrapper {
                margin-left: -280px;
                position: fixed;
                z-index: 1100;
                height: 100vh;
                box-shadow: 20px 0 30px rgba(0,0,0,0.5);
            }
            #sidebar-wrapper.active {
                margin-left: 0;
            }

            /* Ensure the toggle button stays above sidebar on mobile */
            #menu-toggle {
                position: relative;
                z-index: 1101;
            }
            
            /* Overlay to close when clicking outside on mobile */
            .sidebar-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.6);
                backdrop-filter: blur(4px);
                z-index: 1050;
            }
            
            .sidebar-overlay.active {
                display: block;
            }
            
            .modal-content {
                margin: 20px;
                width: calc(100% - 40px);
            }
            
            .modal-header,
            .modal-body,
            .modal-footer-content {
                padding: 20px;
            }
        }
    </style>
</head>

<body>
<div class="sidebar-overlay" id="sidebar-overlay"></div>
<div id="wrapper">

    <!-- Sidebar -->
    <nav id="sidebar-wrapper">
        <div class="sidebar-heading">
            <div class="sidebar-logo">
                <img src="assets/images/log.png" alt="logo">
            </div>
        </div>

        <div class="menu-label">Navigation</div>
        <div class="menu-container">
            <a class="menu-item <?= (basename($_SERVER['PHP_SELF']) == 'main.php') ? 'active' : '' ?>" href="main.php">
                <i class="fa fa-server"></i>
                <span>DNS Servers</span>
            </a>

            <a class="menu-item <?= (basename($_SERVER['PHP_SELF']) == 'user.php') ? 'active' : '' ?>" href="user.php">
                <i class="fa fa-user-circle"></i>
                <span>My Profile</span>
            </a>

            <!-- BUTTON FOR FOOTER1.PHP -->
            <div class="menu-item-footer" id="showFooterBtn">
                <i class="fab fa-telegram"></i>
                <span>System Information</span>
            </div>
        </div>

        <div class="menu-label">System</div>
        <div class="menu-container">
            <a class="menu-item" href="<?= basename($_SERVER["SCRIPT_NAME"]) . '?logout' ?>" style="border-color: rgba(239, 68, 68, 0.1);">
                <i class="fa fa-power-off" style="color: #ef4444;"></i>
                <span style="color: #ef4444;">End Session</span>
            </a>
        </div>
    </nav>

    <!-- Page Content -->
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark ctnav">
            <button type="button" id="menu-toggle">
                <i class="fa fa-bars"></i>
            </button>

            <div id="pageMessages"></div>

            <div class="ml-auto d-flex align-items-center">
                <span class="mr-3 d-none d-md-inline" style="color: var(--text-muted); font-size: 0.85rem;">
                    Hello, <strong style="color: var(--text-main);"><?= $_SESSION['name'] ?></strong>
                </span>
                <a href="<?= basename($_SERVER["SCRIPT_NAME"]) . '?logout' ?>" class="btn-logout">
                    Logout
                </a>
            </div>
        </nav>

        <div class="container-fluid">
            
            <br>
            
            <!-- MODAL FOR FOOTER1.PHP -->
            <div id="footerModal" class="footer-modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4><i class="fas fa-code"></i> System Information</h4>
                        <div class="close-modal" id="closeFooterModal">&times;</div>
                    </div>
                    
                    <div class="modal-body">
                        <!-- footer1.php content -->
                        <div style="text-align: center; margin-bottom: 20px;">
                            <i class="fas fa-terminal" style="font-size: 3rem; color: var(--cyber-blue); margin-bottom: 15px;"></i>
                            <h3 style="color: var(--star-white); margin-bottom: 10px;">ADOO IPTV Admin System</h3>
                            <p style="color: var(--text-muted);">DNS management system 🛡️</p>
                        </div>
                        
                        <div style="background: rgba(0, 243, 255, 0.05); padding: 20px; border-radius: 10px; border: 1px solid rgba(0, 243, 255, 0.1); margin-bottom: 20px;">
                            <h5 style="color: var(--cyber-blue); margin-bottom: 15px;">
                                <i class="fas fa-info-circle"></i> System Details
                            </h5>
                            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
                                <div style="background: rgba(255, 255, 255, 0.03); padding: 15px; border-radius: 8px;">
                                    <i class="fas fa-user-shield" style="color: var(--hologram-teal); margin-right: 10px;"></i>
                                    <strong style="color: var(--star-white);">Developer:</strong>
                                    <span style="color: var(--text-muted);">Emanuel Nascimento</span>
                                </div>
                                <div style="background: rgba(255, 255, 255, 0.03); padding: 15px; border-radius: 8px;">
                                    <i class="fas fa-calendar-alt" style="color: var(--hologram-teal); margin-right: 10px;"></i>
                                    <strong style="color: var(--star-white);">Year:</strong>
                                    <span style="color: var(--text-muted);"><?php echo date("Y") ?></span>
                                </div>
                                <div style="background: rgba(255, 255, 255, 0.03); padding: 15px; border-radius: 8px;">
                                    <i class="fas fa-database" style="color: var(--hologram-teal); margin-right: 10px;"></i>
                                    <strong style="color: var(--star-white);">Database:</strong>
                                    <span style="color: var(--text-muted);">SQLite3</span>
                                </div>
                                <div style="background: rgba(255, 255, 255, 0.03); padding: 15px; border-radius: 8px;">
                                    <i class="fas fa-code-branch" style="color: var(--hologram-teal); margin-right: 10px;"></i>
                                    <strong style="color: var(--star-white);">Version:</strong>
                                    <span style="color: var(--text-muted);">2.0</span>
                                </div>
                            </div>
                        </div>
                        
                        <div style="text-align: center; color: var(--text-muted); font-size: 0.85rem; padding: 15px; border-top: 1px solid rgba(255, 255, 255, 0.05);">
                            <p>
                                <i class="fas fa-exclamation-triangle" style="color: #f59e0b; margin-right: 5px;"></i>
                                System developed for ADOO IPTV
                            </p>
                        </div>
                    </div>
                    
                    <div class="modal-footer-content">
                        <p class="modal-footer-text">
                            ADM - <span class="modal-developer">EONBRY</span> © 
                            <span class="modal-year"><?php echo date("Y") ?></span>
                        </p>
                        
                        <a href="https://t.me/eonbry" target="_blank" class="modal-telegram-link">
                            <i class="fab fa-telegram"></i>
                            Contact via Telegram
                        </a>
                    </div>
                </div>
            </div>

            <!-- Essential Scripts -->
            <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
            <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>
            
	            <script>
	                // Toggle Sidebar
	                document.addEventListener('DOMContentLoaded', function() {
	                    const toggleBtn = document.getElementById('menu-toggle');
	                    const sidebar = document.getElementById('sidebar-wrapper');
	                    const overlay = document.getElementById('sidebar-overlay');
	                    
	                    function toggleSidebar() {
	                        sidebar.classList.toggle('active');
	                        if (overlay) {
	                            overlay.classList.toggle('active');
	                        }
	                    }

	                    if (toggleBtn && sidebar) {
	                        toggleBtn.addEventListener('click', function(e) {
	                            e.preventDefault();
	                            toggleSidebar();
	                        });
	                    }

	                    if (overlay) {
	                        overlay.addEventListener('click', function() {
	                            toggleSidebar();
	                        });
	                    }

                    // Footer modal
                    const showFooterBtn = document.getElementById('showFooterBtn');
                    const footerModal = document.getElementById('footerModal');
                    const closeFooterModal = document.getElementById('closeFooterModal');

                    if (showFooterBtn && footerModal && closeFooterModal) {
                        // Open modal
                        showFooterBtn.addEventListener('click', function() {
                            footerModal.style.display = 'block';
                            document.body.style.overflow = 'hidden';
                        });

                        // Close modal
                        closeFooterModal.addEventListener('click', function() {
                            footerModal.style.display = 'none';
                            document.body.style.overflow = 'auto';
                        });

                        // Close when clicking outside
                        footerModal.addEventListener('click', function(e) {
                            if (e.target === footerModal) {
                                footerModal.style.display = 'none';
                                document.body.style.overflow = 'auto';
                            }
                        });

                        // Close with ESC
                        document.addEventListener('keydown', function(e) {
                            if (e.key === 'Escape' && footerModal.style.display === 'block') {
                                footerModal.style.display = 'none';
                                document.body.style.overflow = 'auto';
                            }
                        });
                    }

                    // Hover effect on footer button
                    const footerBtn = document.querySelector('.menu-item-footer');
                    if (footerBtn) {
                        footerBtn.addEventListener('mouseenter', function() {
                            this.style.transform = 'translateX(5px)';
                        });
                        
                        footerBtn.addEventListener('mouseleave', function() {
                            this.style.transform = 'translateX(0)';
                        });
                    }
                });
            </script>