<?php
session_start();
require_once 'config.php';
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit(); }
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <style>
        body { font-family: sans-serif; background: #0f172a; color: white; padding: 20px; }
        .container { max-width: 800px; margin: auto; background: #1e293b; padding: 20px; border-radius: 12px; }
        input, select { width: 100%; padding: 10px; margin: 10px 0; background: #0f172a; color: white; border: 1px solid #334155; border-radius: 5px; box-sizing: border-box; }
        button { width: 100%; padding: 15px; background: #38bdf8; border: none; font-weight: bold; cursor: pointer; border-radius: 5px; }
        table { width: 100%; margin-top: 30px; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #334155; }
        img { width: 40px; height: 40px; border-radius: 5px; object-fit: cover; }
        .del { color: #f87171; text-decoration: none; }
        .modal { position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.95); z-index:9999; display:flex; justify-content:center; align-items:center; }
    </style>
</head>
<body>

    <?php if ($_SESSION['is_default'] == 1): ?>
    <div class="modal">
        <div style="background:#1e293b; padding:30px; border-radius:15px; width:90%; max-width:400px; text-align:center; border:2px solid #38bdf8;">
            <h2 style="color:#38bdf8;">Change Default Password</h2>
            <p>You must change your credentials to continue.</p>
            <form action="update_pass.php" method="POST">
                <input type="text" name="new_user" placeholder="New Username" required>
                <input type="password" name="new_pass" placeholder="New Password" required>
                <button type="submit">UPDATE & SECURE</button>
            </form>
        </div>
    </div>
    <?php endif; ?>

    <div class="container">
        <div style="display:flex; justify-content: space-between; align-items: center;">
            <h2>AIO Appstore Panel</h2>
            <a href="logout.php" style="color:#64748b; text-decoration:none;">Logout</a>
        </div>
        
        <form action="upload.php" method="POST" enctype="multipart/form-data">
            <input type="text" name="app_name" placeholder="App Name" required>
            <input type="text" name="version" placeholder="Version" required>
            <input type="url" name="logo_url" placeholder="Logo URL (Dropbox raw=1)" required>
            <select name="source_type" onchange="document.getElementById('local').style.display = (this.value=='local'?'block':'none'); document.getElementById('remote').style.display = (this.value=='remote'?'block':'none');">
                <option value="local">Local Upload</option>
                <option value="remote">Dropbox/Remote URL</option>
            </select>
            <div id="local"><input type="file" name="apk_file" accept=".apk"></div>
            <div id="remote" style="display:none"><input type="url" name="external_url" placeholder="Dropbox APK Link (dl=1)"></div>
            <button type="submit">DEPLOY APP</button>
        </form>

        <table>
            <thead><tr><th>Logo</th><th>Name</th><th>Version</th><th>Action</th></tr></thead>
            <tbody>
                <?php
                $res = $conn->query("SELECT * FROM apps ORDER BY id DESC");
                while($row = $res->fetch_assoc()) {
                    echo "<tr>
                        <td><img src='{$row['logo_url']}'></td>
                        <td>{$row['app_name']}</td>
                        <td>{$row['version']}</td>
                        <td><a href='delete.php?id={$row['id']}' class='del' onclick='return confirm(\"Delete?\")'>Remove</a></td>
                    </tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>