<?php
require_once 'config.php';
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');

// This is your site URL - make sure the slash is at the end
$base_url = "https://aioapkrebrands.xyz/appstoremain/";

$sql = "SELECT app_name, version, file_path, logo_url FROM apps ORDER BY id DESC";
$result = $conn->query($sql);
$apps = array();

while($row = $result->fetch_assoc()) {
    $path = $row['file_path'];
    // Logic: If it's a local file, add the URL. If it's Dropbox, leave it alone.
    $download_url = (strpos($path, 'http') === 0) ? $path : $base_url . $path;

    $apps[] = array(
        "name" => $row['app_name'],
        "version" => $row['version'],
        "url" => $download_url,
        "logo" => $row['logo_url']
    );
}
echo json_encode($apps, JSON_PRETTY_PRINT);
?>