<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit(); }
?>
<!DOCTYPE html>
<html>
<head>
    <title>App Panel - Multi-Source</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family: sans-serif; background: #0f3460; color: white; padding: 20px; }
        .container { max-width: 500px; margin: auto; background: #16213e; padding: 25px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.5); }
        input, select { width: 100%; padding: 12px; margin: 10px 0; border-radius: 6px; border: 1px solid #1a1a2e; box-sizing: border-box; background: #1a1a2e; color: white; border: 1px solid #00d2ff; }
        button { width: 100%; padding: 12px; background: #00d2ff; color: #16213e; border: none; border-radius: 6px; cursor: pointer; font-weight: bold; margin-top: 10px; }
        .hidden { display: none; }
        label { font-size: 0.9em; color: #00d2ff; }
    </style>
    <script>
        function toggleSource() {
            var source = document.getElementById("source_type").value;
            document.getElementById("local_upload").classList.toggle("hidden", source !== "local");
            document.getElementById("remote_url").classList.toggle("hidden", source !== "remote");
        }
    </script>
</head>
<body>
    <div class="container">
        <h2>Add New App</h2>
        <form action="upload.php" method="POST" enctype="multipart/form-data">
            <input type="text" name="app_name" placeholder="App Name" required>
            <input type="text" name="version" placeholder="Version (e.g. 1.0)" required>
            
            <label>App Logo (Dropbox URL):</label>
            <input type="url" name="logo_url" placeholder="https://dropbox.com/...logo.png?raw=1">
            
            <label>Link Source:</label>
            <select id="source_type" name="source_type" onchange="toggleSource()">
                <option value="local">Upload APK from Computer</option>
                <option value="remote">External URL (Dropbox/Downloader)</option>
            </select>

            <div id="local_upload">
                <input type="file" name="apk_file" accept=".apk">
            </div>

            <div id="remote_url" class="hidden">
                <input type="url" name="external_url" placeholder="https://dropbox.com/s/myapp.apk?dl=1">
            </div>

            <button type="submit">Deploy to Store</button>
        </form>
    </div>
</body>
</html>
