<?php
include ('includes/header.php');

$base_file = basename($_SERVER['PHP_SELF']);
$table_name = "extra_accounts";

// Handle Deletion
if (isset($_GET['delete'])) {
    $deleteId = sanitize($_GET['delete']); 
    $db->delete($table_name, "id='{$deleteId}'");
    echo "<script>window.location.href='$base_file?status=2'</script>";
    exit;
}

// Handle Update POST
if (isset($_POST['submitU']) && isset($_GET['update'])) {
    $update_id = sanitize($_GET['update']);
    $expiryDate = new DateTime($_POST['expiry']);
    $status = ($expiryDate >= new DateTime()) ? 'Active' : 'Expired';

    $data = [
        'username' => $_POST['username'],
        'password' => $_POST['password'],
        'status'   => $status,
        'expiry'   => $_POST['expiry']
    ];
    $db->update($table_name, $data, "id='{$update_id}'");
    echo "<script>window.location.href='$base_file?status=1'</script>";
    exit;
}

// Handle Create POST
if (isset($_POST['submit'])) {
    $expiryDate = new DateTime($_POST['expiry']);
    $status = ($expiryDate >= new DateTime()) ? 'Active' : 'Expired';

    $data = [
        'username' => $_POST['username'],
        'password' => $_POST['password'],
        'status' => $status,
        'expiry' => $_POST['expiry']
    ];
    $db->insert($table_name, $data);
    echo "<script>window.location.href='$base_file?status=1'</script>";
    exit;
}

// ---------------- HTML VIEW LOGIC ----------------

if (isset($_GET['create'])) { ?>
    <div class="col-md-8 mx-auto mt-4">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning text-center">
                <h2><i class="fa fa-user-plus"></i> Create Extra Account</h2>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label>Username</label>
                        <input class="form-control" name="username" type="text" required/>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input class="form-control" name="password" type="text" required/>
                    </div>
                    <div class="form-group">
                        <label>Expiry Date</label>
                        <input class="form-control" name="expiry" type="date" required/>
                    </div>
                    <div class="text-center">
                        <button class="btn btn-info" name="submit" type="submit">Submit</button>
                        <a href="<?= $base_file ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php } elseif (isset($_GET['update'])) { 
    $update_id = sanitize($_GET['update']);
    $resU = $db->select($table_name, '*', "id='{$update_id}'");
    $rowU = $resU[0] ?? null;
    if(!$rowU) { echo "Account not found."; exit; }
?>
    <div class="col-md-8 mx-auto mt-4">
        <div class="card bg-primary text-white">
            <div class="card-header card-header-warning text-center">
                <h2><i class="fa fa-edit"></i> Edit Account</h2>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label>Username</label>
                        <input class="form-control" name="username" value="<?=$rowU['username']?>" type="text" required/>
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input class="form-control" name="password" value="<?=$rowU['password']?>" type="text" required/>
                    </div>
                    <div class="form-group">
                        <label>Expiry Date</label>
                        <input class="form-control" name="expiry" type="date" value="<?=$rowU['expiry']?>" required/>
                    </div>
                    <div class="text-center">
                        <button class="btn btn-info" name="submitU" type="submit">Update Account</button>
                        <a href="<?= $base_file ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php } else { ?>
    <div class="col-md-12 mx-auto">
        <div class="card bg-primary text-white">
            <div class="card-header text-center">
                <h2><i class="fa fa-users"></i> Extra Accounts</h2>
            </div>
            <div class="card-body">
                <div class="text-center mb-3">
                    <a href="?create" class="btn btn-info">New Account</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped table-dark">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Password</th>
                                <th>Status</th>
                                <th>Expiry</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $res = $db->select($table_name);
                            foreach ($res as $row) {
                                $isExpired = (new DateTime($row['expiry']) < new DateTime());
                                $statusHTML = $isExpired ? 
                                    '<span class="status-expired">Expired</span>' : 
                                    '<span class="status-active">Active</span>';
                            ?>
                                <tr>
                                    <td><?= $row['id'] ?></td>
                                    <td><?= htmlspecialchars($row['username']) ?></td>
                                    <td><?= htmlspecialchars($row['password']) ?></td>
                                    <td><?= $statusHTML ?></td>
                                    <td><?= $row['expiry'] ?></td>
                                    <td>
                                        <a class="btn btn-sm btn-info" href="?update=<?= $row['id'] ?>"><i class="fa fa-pencil"></i></a>
                                        <a class="btn btn-sm btn-danger" href="?delete=<?= $row['id'] ?>" onclick="return confirm('Delete this user?')"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php include ('includes/footer.php');?>