<?php
if(session_status() === PHP_SESSION_NONE) session_start();
ini_set('display_errors', 0); // Set to 1 if you need to debug errors

include(__DIR__ . '/functions.php');

// 1. Get the admin username from DB
$log_check = $db->select('user', '*', 'id = :id', '', [':id' => 1]);
$admin_username = !empty($log_check) ? $log_check[0]['username'] : null;

// 2. Security: Redirect to login if session doesn't match DB admin
if (!isset($_SESSION['name']) || $_SESSION['name'] !== $admin_username) {
    header("Location: index.php");
    exit;
}

// 3. Logout Logic
if (isset($_GET['logout'])) {
    session_unset();
    session_destroy();
    header("Location: index.php");
    exit;
}

// 4. Session Timeout (15 minutes)
$time = $_SERVER['REQUEST_TIME'];
$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && ($time - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: index.php");
    exit;
}
$_SESSION['LAST_ACTIVITY'] = $time;

// Sanitization Function
function sanitize($data) {
    return SQLite3::escapeString(htmlspecialchars(trim($data), ENT_QUOTES));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    <style>
        body { background-color: #181828; color: #fff; }
        #js-particles { position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: -1; }
        .card { background-color: rgba(255, 255, 255, 0.1); border: none; }
        .status-active { background-color: #28a745; color: white; padding: 2px 8px; border-radius: 4px; }
        .status-expired { background-color: #dc3545; color: white; padding: 2px 8px; border-radius: 4px; }
        /* Ensure sidebar content is visible */
        #page-content-wrapper { width: 100%; padding: 20px; }
    </style>
</head>
<body>
<div id="js-particles"></div>
<div class="d-flex" id="wrapper">
    <div class="bg-dark border-right" id="sidebar-wrapper">
        <div class="sidebar-heading text-white">Admin Panel</div>
        <div class="list-group list-group-flush">
            <a class="list-group-item list-group-item-action bg-dark text-white" href="main.php"><i class="fa fa-cogs"></i> DNS Settings</a>
            <a class="list-group-item list-group-item-action bg-dark text-white" href="actusers.php"><i class="fa fa-user-plus"></i> Extra Accounts</a>
            <a class="list-group-item list-group-item-action bg-dark text-white" href="user.php"><i class="fa fa-user"></i> Credentials</a>
        </div>
    </div>
    <div id="page-content-wrapper">
        <nav class="navbar navbar-expand-lg navbar-dark bg-transparent">
            <button class="btn btn-primary" id="menu-toggle"><i class="fa fa-bars"></i></button>
            <a href="?logout" class="btn btn-danger ml-auto">Logout</a>
        </nav>
        <div class="container-fluid">