<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/functions.php';
start_panel_session();
$active = $active ?? 'dashboard';
$title  = $title  ?? 'Panel';
$message = $message ?? '';
$messageType = $messageType ?? 'success';
$user = $_SESSION['pp_user'] ?? '';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo safe_str($title); ?></title>
  <link rel="stylesheet" href="assets/css/bootstrap.css">
  <link rel="stylesheet" href="assets/css/simple-sidebar.css">
  <link rel="stylesheet" href="assets/css/style.css">
  <link rel="stylesheet" href="assets/css/custom.css">
  <link rel="stylesheet" href="assets/css/signin.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<style>
body{
  background:
    linear-gradient(rgba(5,8,20,0.82), rgba(5,8,20,0.82)),
    url("assets/img/bg.jpg?v=<?php echo @filemtime(__DIR__ . '/../assets/img/bg.jpg'); ?>")
    center center / cover no-repeat fixed;
}
</style>
<?php include __DIR__ . '/background.php'; ?>
</head>

<body data-message="<?php echo safe_str($message); ?>" data-message-type="<?php echo safe_str($messageType); ?>">
<div class="d-flex" id="wrapper">
  <div id="sidebar-wrapper">
    <div class="sidebar-heading">
      <div class="sidebar-logo" style="padding:12px 14px;">
        <div style="font-weight:700;color:#fff;font-size:16px;letter-spacing:.2px;"><img src="assets/img/logo.png?v=<?php echo @filemtime(__DIR__ . '/../assets/img/logo.png'); ?>" style="height:28px;margin-right:8px;"> Wave Panel</div>
        <div style="font-size:12px;color:#9aa4b2;">Portal control</div>
      </div>
    </div>

    <div class="list-group list-group-flush">
      <a class="list-group-item list-group-item-action <?php echo $active==='dashboard'?'active':''; ?>" href="dashboard.php">
        <i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard
      </a>
      <a class="list-group-item list-group-item-action <?php echo $active==='portals'?'active':''; ?>" href="portals.php">
        <i class="fa fa-cogs"></i>&nbsp;&nbsp;DNS / Portals
      </a>
      <a class="list-group-item list-group-item-action <?php echo $active==='appearance'?'active':''; ?>" href="appearance.php">
        <i class="fa fa-paint-brush"></i>&nbsp;&nbsp;Appearance
      </a>
      <a class="list-group-item list-group-item-action <?php echo $active==='security'?'active':''; ?>" href="security.php">
        <i class="fa fa-lock"></i>&nbsp;&nbsp;Security
      </a>
    </div>
  </div>

  <div id="page-content-wrapper">
    <nav class="navbar navbar-expand-lg navbar-dark ctnav">
      <button class="btn btn-primary" id="menu-toggle"><i class="fa fa-bars"></i></button>
      <div class="center" id="pageMessages"></div>
      <?php if ($user): ?>
      <a href="logout.php" class="btn btn-danger ml-auto mr-1"><i class="fa fa-sign-out"></i> Logout</a>
      <?php endif; ?>
    </nav>
    <div class="container-fluid">
      <br>
