<?php
include(__DIR__ . '/../includes/functions.php'); 
session_start(); 


$mac_address = '00:00:00:00:00';
$playlist_id;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $json_data = file_get_contents('php://input');
    $payload = json_decode($json_data, true);
    if ($payload !== null && isset($payload['data'])) {
        $inner_data = json_decode($payload['data'], true);
        if ($inner_data !== null) {
            $mac_address = strtolower($inner_data['mac_address']);
            $playlist_id = strtolower($inner_data['playlistId']);
        }
    } 
} else {
    echo "This endpoint only accepts POST requests.";
}


function deleteplaylist($playid,$mac){
    global $db;
    $ret = $db->select(
    'ibof',
    '*',
    'plid = :plid AND macad = :macad',
    '',
    [
        ':plid'  => $playid,
        ':macad' => $mac
    ]
    );
    
    $id =  $ret[0]['id'] ? : '';
    $name =  $ret[0]['name'];
    
    
    $success = [
     'status' => 'success',
     'message' => 'Playlist deleted successfully'
     ];
     
    $error = [
     'status' => 'error',
     'message' => 'There was a problem. Please try again later.'
     ]; 
    
    if($id == ''){
        return $error;
    }else{
        $db->delete('ibof', 'id = :id',[':id' => $id]);
        return $success;
    }
}


header('Content-Type: application/json');
echo json_encode(deleteplaylist($playlist_id,$mac_address));