<?php
include(__DIR__ . '/../includes/functions.php');

// Check if username is provided in the request
if (!isset($_GET['username'])) {
    outecho(0); // No username provided
    exit;
}

// Fetch user data from the database
$ret = $db->select('menualusers', '*', 'username = :username', '', [':username' => $_GET['username']]);

// Check user authentication status and generate response
if (paneluser($ret)) {
    outecho(1); // User authenticated
} else {
    outecho(2); // Authentication failed
}

function paneluser($dbdata) {
    // Check if user data exists
    if (!$dbdata || empty($dbdata)) {
        return false; // User not found
    }

    // Extract user information
    $expired = null;
    $id = $dbdata[0]['id'];
    $title = $dbdata[0]['title'];
    $username = $dbdata[0]['username'];
    $password = $dbdata[0]['password'];
    $expired = $dbdata[0]['expire_date'];

    $expiredT = (time() > strtotime(@$expired));
    if ($expiredT) {
        $expired = 0;
    } else {
        $expired = 1;
    }

    // Check username, password, and expiration date
    if (isset($_GET['password']) && $_GET['username'] == $username && $_GET['password'] == $password && $expired >= 1) {
       return true;
    } else {
        return false; // Authentication failed
    }
}

function outecho($status) {
    $response = null;

    // Generate response based on status
    if ($status == 1) {
        $response = array(
            "user_info" => array(
                "username" => $_GET['username'],
                "password" => $_GET['password'],
                "message" => "",
                "auth" => 1,
                "status" => "Active",
                "exp_date" => "1733238335",
                "is_trial" => "0",
                "active_cons" => "0",
                "created_at" => "1668783935",
                "max_connections" => "1",
                "allowed_output_formats" => ["m3u8", "ts"]
            ),
            "server_info" => array(
                "url" => "rtxrebrand.com",
                "port" => "25443",
                "https_port" => "25463",
                "server_protocol" => "http",
                "rtmp_port" => "25444",
                "timezone" => "Europe/Athens",
                "timestamp_now" => 1712622569,
                "time_now" => "2024-04-09 03:29:29"
            )
        );
    } else if ($status == 2) {
        $response = array(
            "user_info" => array(
                "username" => $_GET['username'],
                "password" => $_GET['password'],
                "message" => "",
                "auth" => 0,
                "status" => "Expired",
                "exp_date" => "1733238335",
                "is_trial" => "0",
                "active_cons" => "0",
                "created_at" => "1668783935",
                "max_connections" => "1",
                "allowed_output_formats" => ["m3u8", "ts"]
            ),
            "server_info" => array(
                "url" => "rtxrebrand.com",
                "port" => "25443",
                "https_port" => "25463",
                "server_protocol" => "http",
                "rtmp_port" => "25444",
                "timezone" => "Europe/Athens",
                "timestamp_now" => 1712622569,
                "time_now" => "2024-04-09 03:29:29"
            )
        );
    } else {
        $response = array(
            "error" => "Invalid status"
        );
    }

    header('Content-type: application/json; charset=UTF-8');
    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}
?>