<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) {
    header("Location: adm/login.php");
    exit;
}

require_once __DIR__ . '/db.php';

$msg = "";
$erro = "";

/* GERAR CÓDIGO APK */
function gerarCodigoAPK() {
    return strtoupper(substr(md5(uniqid().rand()), 0, 6));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nome      = trim($_POST['nome']);
    $descricao = trim($_POST['descricao']);
    $categoria = trim($_POST['categoria']);

    $link_apk   = trim($_POST['link_apk']);
    $apk_upload = $_FILES['apk_upload'];

    $link_img   = trim($_POST['link_img']);
    $img_upload = $_FILES['img_upload'];

    if ($nome == "") $erro = "O nome é obrigatório.";

    if (!$erro) {

        /* CRIA APP */
        $stmt = $db->prepare("INSERT INTO apps (nome, descricao, categoria) VALUES (?, ?, ?)");
        $stmt->execute([$nome, $descricao, $categoria]);

        $app_id = $db->lastInsertId();

        /* GERA CÓDIGO APK */
        $codigo = gerarCodigoAPK();
        $stmt = $db->prepare("INSERT INTO codigo_apk (app_id, codigo) VALUES (?, ?)");
        $stmt->execute([$app_id, $codigo]);

        /* PASTA */
        $dir = __DIR__ . "/apps/$app_id/";
        if (!is_dir($dir)) mkdir($dir, 0777, true);

        /* APK */
        $arquivo_apk = null;
        $url_apk = null;

        if ($link_apk != "") {
            $url_apk = $link_apk;

        } elseif ($apk_upload['error'] === 0) {
            $ext = strtolower(pathinfo($apk_upload['name'], PATHINFO_EXTENSION));
            if ($ext !== 'apk') {
                $erro = "Envie apenas APK.";
            } else {
                $arquivo_apk = "app.apk";
                move_uploaded_file($apk_upload['tmp_name'], $dir . $arquivo_apk);
            }
        }

        /* IMAGEM */
        $imagem = null;

        if ($link_img != "") {
            $imagem = $link_img;

        } elseif ($img_upload['error'] === 0) {
            $ext = strtolower(pathinfo($img_upload['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, ['png','jpg','jpeg'])) {
                $erro = "Imagem inválida.";
            } else {
                $imagem = "icone.png";
                move_uploaded_file($img_upload['tmp_name'], $dir . $imagem);
            }
        }

        /* FINALIZA */
        if (!$erro) {
            $stmt = $db->prepare("UPDATE apps SET url_apk=?, arquivo_apk=?, imagem=? WHERE id=?");
            $stmt->execute([$url_apk, $arquivo_apk, $imagem, $app_id]);

            $msg = "Aplicativo cadastrado com sucesso!";
            $redirecionar = true;
        }
    }
}

include 'includes/header.php';
?>



<!-- ==== ESTILO ==== -->

<style>
.form-container{
    background:#111827cc;
    padding:35px;
    border-radius:16px;
    width:100%;
    max-width:900px;
    margin-left:0px; 
    box-shadow:0 0 25px rgba(0,0,0,.40);
    backdrop-filter:blur(12px);
    box-sizing:border-box;
    border:1px solid rgba(255,255,255,0.20);
}
.form-container h2{
    margin-bottom:25px;
    color:white;
    text-align:center;
    font-weight:600;
    font-size:22px;
}
.label{
    color:#cbd5e1;
    margin-bottom:6px;
    display:block;
    font-size:15px;
}
.input{
    width:100%;
    padding:12px;
    border-radius:10px;
    border:none;
    background:#1f2937;
    color:white;
    margin-bottom:18px;
    font-size:15px;
    box-sizing:border-box;
}
.btn-save{
    width:100%;
    padding:14px;
    background:#2563eb;
    color:white;
    border:none;
    border-radius:10px;
    font-size:16px;
    cursor:pointer;
    transition:.2s;
}
.btn-save:hover{ background:#1d4ed8; }

.msg-success, .msg-error{
    padding:12px;
    border-radius:10px;
    margin-bottom:18px;
    text-align:center;
    font-weight:bold;
}
.msg-success{ background:#065f46; color:#ecfdf5; }
.msg-error{ background:#7f1d1d; color:#fee2e2; }

.section-title{
    color:#fff;
    font-size:17px;
    margin:20px 0 10px 0;
    border-left:4px solid #3b82f6;
    padding-left:10px;
}

@media (max-width: 600px){
    body{ padding:15px; overflow-x:hidden; }
    .main-content{ padding-top:60px; margin-left:0 !important; }
    .form-container{
        width:100%;
        padding:22px;
        border-radius:12px;
        margin:auto;
        box-shadow:none;
    }
}
</style>

<!-- ==== HTML ==== -->

<div class="main-content">
<div class="main-wrapper">
<div class="form-container">

    <h2><i class="fa-solid fa-plus"></i> Cadastro de Aplicativo</h2>

    <?php if ($erro): ?>
        <div class="msg-error"><?= $erro ?></div>
    <?php endif; ?>

    <?php if ($msg): ?>
        <div class="msg-success"><?= $msg ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">

        <label class="label">Nome:</label>
        <input type="text" class="input" name="nome" required>

        <label class="label">Descrição:</label>
        <textarea class="input" name="descricao"></textarea>

        <label class="label">Categoria:</label>
        <input type="text" class="input" name="categoria">

        <div class="section-title">APK</div>

        <label class="label">Link do APK:</label>
        <input type="text" class="input" name="link_apk" placeholder="https://...">

        <label class="label">Ou enviar arquivo APK:</label>
        <input type="file" class="input" name="apk_upload">

        <div class="section-title">Ícone / Imagem</div>

        <label class="label">Link da imagem:</label>
        <input type="text" class="input" name="link_img" placeholder="https://...">

        <label class="label">Ou enviar imagem:</label>
        <input type="file" class="input" name="img_upload">

        <br>
        <button class="btn-save">
            <i class="fa-solid fa-check"></i> Salvar Aplicativo
        </button>

    </form>

</div>
</div>
</div>

<!-- ==== REDIRECIONAMENTO ==== -->

<script>
<?php if (!empty($redirecionar)): ?>
    setTimeout(() => {
        window.location.href = "gerenciar.php";
    }, 2000);
<?php endif; ?>
</script>
