<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) { 
    header("Location: adm/login.php"); 
    exit;
}

require_once __DIR__ . "/db.php";
include 'includes/header.php';

/* ======================
   BUSCA DO BANCO REAL
====================== */
$stmt = $db->prepare("SELECT id, nome, imagem, downloads FROM apps ORDER BY downloads DESC");
$stmt->execute();
$apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total = array_sum(array_column($apps, "downloads"));

/* RESET */
if (isset($_GET["reset"])) {
    $db->exec("UPDATE apps SET downloads = 0");
    header("Location: adm_downloads.php?ok=1");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Downloads</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>

/* CONTAINER GLOBAL DO PAINEL */
.main-content{
    margin-left:260px;
    padding:30px;
}

/* TITULO */
h2{
    color:white;
    font-size:22px;
    margin-bottom:22px;
    font-weight:600;
}

/* CAIXA TOTAL */
.total-box{
    background:#111827cc;
    padding:18px;
    border-radius:14px;
    margin-bottom:25px;
    color:#38bdf8;
    text-align:center;
    border:1px solid rgba(255,255,255,0.15);
    font-size:18px;
}

/* BOTÃO RESET */
.reset-btn{
    background:#dc2626;
    padding:12px 20px;
    border:none;
    border-radius:10px;
    font-size:15px;
    font-weight:bold;
    color:white;
    cursor:pointer;
    margin-bottom:25px;
}
.reset-btn:hover{
    background:#b91c1c;
}

/* GRID DE CARDS */
.cards-grid{
    display:grid;
    grid-template-columns:repeat(auto-fill,minmax(250px,1fr));
    gap:18px;
}

/* CARD PEQUENO */
.card{
    background:#111827cc;
    border-radius:14px;
    padding:14px;
    border:1px solid rgba(255,255,255,0.12);
    backdrop-filter:blur(10px);
    box-shadow:0 0 18px rgba(0,0,0,0.35);
    position:relative;
    display:flex;
    flex-direction:column;
    align-items:center;
    text-align:center;
}

/* IMAGEM */
.card img{
    width:80px;
    height:80px;
    object-fit:cover;
    border-radius:12px;
    background:#000;
    margin-bottom:12px;
}

/* TITULO */
.title{
    color:white;
    font-size:16px;
    font-weight:600;
    margin-bottom:6px;
}

/* DOWNLOADS */
.downs{
    color:#cbd5e1;
    font-size:14px;
}

/* TROFÉUS */
.trofeu{
    position:absolute;
    right:10px;
    top:10px;
    font-size:24px;
}
.ouro{ color:#FFD700; }
.prata{ color:#C0C0C0; }
.bronze{ color:#CD7F32; }

/* MOBILE */
@media(max-width:600px){
    .main-content{
        margin-left:0;
        padding:15px;
    }
    .card img{
        width:70px;
        height:70px;
    }
}
</style>

</head>
<body>

<div class="main-content">

<h2><i class="fa-solid fa-chart-simple"></i> Estatísticas de Downloads</h2>

<?php if(isset($_GET["ok"])): ?>
    <div class="total-box" style="color:#10b981;font-weight:bold;">
        Downloads resetados com sucesso!
    </div>
<?php endif; ?>

<div class="total-box">
    Total de Downloads: <strong><?= $total ?></strong>
</div>

<button class="reset-btn" onclick="resetar()">
    <i class="fa-solid fa-trash"></i> Resetar Downloads
</button>

<div class="cards-grid">

<?php
$i=1;
foreach($apps as $app):

    $trofeu = "";
    if($i == 1) $trofeu = "<span class='trofeu ouro'>🥇</span>";
    if($i == 2) $trofeu = "<span class='trofeu prata'>🥈</span>";
    if($i == 3) $trofeu = "<span class='trofeu bronze'>🥉</span>";

    $img = file_exists("apps/{$app['id']}/{$app['imagem']}")
        ? "apps/{$app['id']}/{$app['imagem']}"
        : "logo/default.png";
?>

<div class="card">
    <?= $trofeu ?>
    <img src="<?= $img ?>">
    <div class="title"><?= $app["nome"] ?></div>
    <div class="downs">Downloads: <?= $app["downloads"] ?></div>
</div>

<?php
$i++;
endforeach;
?>

</div>

</div>

<script>
function resetar(){
    Swal.fire({
        title:"Zerar Downloads?",
        text:"Isto limpará todos os contadores.",
        icon:"warning",
        showCancelButton:true,
        confirmButtonText:"Sim",
        cancelButtonText:"Cancelar",
        confirmButtonColor:"#dc2626"
    }).then(r=>{
        if(r.isConfirmed){
            window.location="adm_downloads.php?reset=1";
        }
    });
}
</script>

</body>
</html>
