<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


require_once __DIR__ . '/includes/config.php';

$db = new PDO('sqlite:' . DB_PATH);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

/* TABELAS */
$db->exec("CREATE TABLE IF NOT EXISTS apps (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  nome TEXT NOT NULL,
  descricao TEXT,
  categoria TEXT,
  codigo_downloader TEXT,
  url_apk TEXT,
  arquivo_apk TEXT,
  imagem TEXT,
  ativo INTEGER DEFAULT 1,
  downloads INTEGER DEFAULT 0,
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP
);");

$db->exec("CREATE TABLE IF NOT EXISTS users (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  username TEXT UNIQUE,
  pass TEXT,
  role TEXT DEFAULT 'admin',
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);");

$db->exec("CREATE TABLE IF NOT EXISTS configuracoes (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  chave TEXT UNIQUE,
  valor TEXT
);");

$db->exec("CREATE TABLE IF NOT EXISTS aviso (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  titulo TEXT,
  texto TEXT,
  botao_texto TEXT,
  botao_link TEXT,
  imagem TEXT,
  ativo INTEGER DEFAULT 0
);");

$db->exec("CREATE TABLE IF NOT EXISTS codigo_apk (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    app_id INTEGER NOT NULL,
    codigo TEXT NOT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP
);");

/* ADMIN PADRÃO */
$exists = $db->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'];

if($exists == 0){
    $hash = password_hash('trocar123', PASSWORD_DEFAULT);
    $stmt = $db->prepare("INSERT INTO users (username, pass, role) VALUES (?, ?, ?)");
    $stmt->execute(['admin', $hash, 'superadmin']);
}

/* LOGO PADRÃO */
$stmt = $db->prepare("INSERT OR IGNORE INTO configuracoes (chave, valor) VALUES (?, ?)");
$stmt->execute(['logo', 'logo.png']);

echo "BANCO CRIADO COM SUCESSO!";
