<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: adm/login.php");
    exit;
}

require_once __DIR__ . '/db.php';

if (!isset($_GET['id'])) exit("ID inválido");

$id = intval($_GET['id']);

/* BUSCAR APP */
$stmt = $db->prepare("SELECT * FROM apps WHERE id = ?");
$stmt->execute([$id]);
$app = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$app) exit("Aplicativo não encontrado!");


/* BUSCAR CÓDIGO APK */
$stmtCod = $db->prepare("SELECT codigo FROM codigo_apk WHERE app_id = ?");
$stmtCod->execute([$id]);
$codigoAPK = $stmtCod->fetchColumn();

$msg = "";
$erro = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nome        = trim($_POST['nome']);
    $descricao   = trim($_POST['descricao']);
    $categoria   = trim($_POST['categoria']);
    $codigo_down = trim($_POST['codigo_downloader']);

    $link_apk   = trim($_POST['link_apk']);
    $apk_upload = $_FILES['apk_upload'];

    $link_img   = trim($_POST['link_img']);
    $img_upload = $_FILES['img_upload'];

    if ($nome == "") $erro = "O nome é obrigatório.";

    if (!$erro) {

        /* ATUALIZA DADOS */
        $stmtU = $db->prepare("
            UPDATE apps SET 
                nome=?, descricao=?, categoria=?, 
                codigo_downloader=?
            WHERE id=?
        ");
        $stmtU->execute([$nome, $descricao, $categoria, $codigo_down, $id]);

        /* PASTA */
        $dir = __DIR__ . "/apps/$id/";
        if (!is_dir($dir)) mkdir($dir, 0777, true);

        /* APK */
        if ($link_apk !== "") {
            $stmt = $db->prepare("UPDATE apps SET url_apk=?, arquivo_apk=NULL WHERE id=?");
            $stmt->execute([$link_apk, $id]);

        } elseif ($apk_upload['error'] === 0) {

            $ext = strtolower(pathinfo($apk_upload['name'], PATHINFO_EXTENSION));
            if ($ext !== 'apk') {
                $erro = "Envie um arquivo APK válido.";
            } else {
                move_uploaded_file($apk_upload['tmp_name'], $dir . "app.apk");

                $stmt = $db->prepare("UPDATE apps SET url_apk=NULL, arquivo_apk='app.apk' WHERE id=?");
                $stmt->execute([$id]);
            }
        }

        /* IMAGEM */
        if ($link_img !== "") {

            $stmt = $db->prepare("UPDATE apps SET imagem=? WHERE id=?");
            $stmt->execute([$link_img, $id]);

        } elseif ($img_upload['error'] === 0) {

            $ext = strtolower(pathinfo($img_upload['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, ['png','jpg','jpeg'])) {
                $erro = "Imagem inválida.";
            } else {
                move_uploaded_file($img_upload['tmp_name'], $dir . "icone.png");

                $stmt = $db->prepare("UPDATE apps SET imagem='icone.png' WHERE id=?");
                $stmt->execute([$id]);
            }
        }

        if (!$erro) {
            $msg = "Aplicativo atualizado com sucesso!";
            echo "<script>
                    setTimeout(()=>{ window.location.href='gerenciar.php'; }, 2000);
                  </script>";
        }
    }
}

include 'includes/header.php';
?>


<style>
.form-container{
    background:#111827cc;
    padding:35px;
    border-radius:16px;
    max-width:750px;
    margin:-10px;
    box-shadow:0 0 25px rgba(0,0,0,.40);
    border:1px solid rgba(255,255,255,0.20);
    backdrop-filter:blur(12px);
}

/* TITULO */
.form-container h2{
    margin-bottom:25px;
    color:white;
    text-align:center;
    font-weight:600;
}

/* CAMPOS */
.label{
    color:#cbd5e1;
    margin-bottom:6px;
    display:block;
}

.input{
    width:100%;
    padding:12px;
    border-radius:10px;
    border:none;
    background:#1f2937;
    color:white;
    margin-bottom:18px;
    font-size:15px;
}

/* READONLY */
.input[readonly]{
    background:#2d364b !important;
    color:#ffffff !important;
    cursor:not-allowed;
    opacity:.9;
}

/* BOTÃO */
.btn-save{
    width:100%;
    padding:14px;
    background:#2563eb;
    color:white;
    border:none;
    border-radius:10px;
    cursor:pointer;
    font-size:16px;
}
.btn-save:hover{ background:#1d4ed8; }

.msg-success, .msg-error{
    padding:12px;
    border-radius:10px;
    text-align:center;
    font-weight:bold;
    margin-bottom:15px;
}
.msg-success{ background:#065f46; color:#ecfdf5; }
.msg-error{ background:#7f1d1d; color:#fee2e2; }

.section-title{
    color:white;
    font-size:17px;
    margin:15px 0;
    border-left:4px solid #3b82f6;
    padding-left:10px;
}

.input {
    user-select: text !important;
    pointer-events: auto !important;
}


</style>

<div class="main-content">
<div class="main-wrapper">
<div class="form-container">

<h2><i class="fa-solid fa-pen"></i> Editar Aplicativo</h2>

<?php if ($msg): ?><div class="msg-success"><?= $msg ?></div><?php endif; ?>
<?php if ($erro): ?><div class="msg-error"><?= $erro ?></div><?php endif; ?>

<form method="POST" enctype="multipart/form-data">

    <label class="label">Nome:</label>
    <input type="text" class="input" name="nome" value="<?= $app['nome'] ?>">

    <label class="label">Descrição:</label>
    <textarea class="input" name="descricao"><?= $app['descricao'] ?></textarea>

    <label class="label">Categoria:</label>
    <input type="text" class="input" name="categoria" value="<?= $app['categoria'] ?>">

    <!-- CÓDIGO APK REAL (não editável) -->
    <label class="label">Código APK (automático):</label>
    <input type="text" class="input" value="<?= $codigoAPK ?>" readonly>

    <!-- CÓDIGO DOWNLOADER (editável) -->
    <label class="label">Código Downloader:</label>
    <input 
    type="text" 
    class="input" 
    name="codigo_downloader" 
    value="<?= $app['codigo_downloader'] ?>"
    style="user-select: auto !important; pointer-events: auto !important;"
    onpaste="return true;"
>


    <!-- CÓDIGO NTDOWN -->
    <!--<label class="label">Código NTDown:</label>
    <input type="text" class="input" name="codigo_ntdown" value="<?= $app['codigo_ntdown'] ?>">-->

    <div class="section-title">APK</div>

    <label class="label">Link (opcional):</label>
    <input type="text" class="input" name="link_apk" value="<?= $app['url_apk'] ?>">

    <label class="label">Ou enviar novo APK:</label>
    <input type="file" class="input" name="apk_upload">

    <div class="section-title">Imagem Atual</div>

    <?php
        $localImg = "apps/$id/icone.png";
        $imgSrc = (!empty($app['imagem']) && filter_var($app['imagem'], FILTER_VALIDATE_URL))
            ? $app['imagem']
            : (file_exists($localImg) ? $localImg : "logo/default.png");
    ?>

    <img src="<?= $imgSrc ?>?v=<?= time() ?>" style="width:120px; height:120px; border-radius:12px; margin-bottom:15px;">

    <label class="label">Novo link da imagem:</label>
    <input type="text" class="input" name="link_img" placeholder="https://...">

    <label class="label">Ou enviar nova imagem:</label>
    <input type="file" class="input" name="img_upload">

    <button class="btn-save"><i class="fa-solid fa-check"></i> Salvar Alterações</button>

</form>

</div>
</div>
</div>

<script>
setTimeout(()=>{
    document.querySelectorAll('.msg-success,.msg-error').forEach(el=>{
        el.style.opacity="0";
        el.style.transition=".4s";
        setTimeout(()=>el.remove(),400);
    });
}, 3000);
</script>

<script>
document.addEventListener("paste", e => {
    // desbloqueia tudo
});
</script>

