<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xx ------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) { header("Location: adm/login.php"); exit; }

$alertPath = __DIR__ . "/config/alert.json";

if (!file_exists($alertPath)) {
    file_put_contents($alertPath, json_encode([
        "enabled"=>false,
        "title"=>"",
        "text"=>"",
        "confirm_text"=>"",
        "cancel_text"=>"",
        "link"=>"",
        "image_url"=>"",
        "image_width"=>80,
        "image_height"=>80
    ], JSON_PRETTY_PRINT));
}

$alert = json_decode(file_get_contents($alertPath), true);

$msg = isset($_GET['ok']) ? "Salvo com sucesso!" : "";
?>

<?php include 'includes/header.php'; ?>

<style>
.page-box{
    background:#111827cc;
    padding:30px;
    border-radius:16px;
    max-width:900px;
    margin-left:260px;
    margin-top:20px;
    box-shadow:0 0 25px rgba(0,0,0,.40);
    border:1px solid rgba(255,255,255,0.25);
    backdrop-filter:blur(12px);
}
.section-title{
    color:#fff;
    font-size:18px;
    margin:20px 0 10px;
    border-left:4px solid #3b82f6;
    padding-left:10px;
}
.label{
    color:#cbd5e1;
    margin-bottom:6px;
    display:block;
    font-size:15px;
}
.input-text{
    width:98%;
    padding:12px;
    border-radius:10px;
    border:none;
    margin-bottom:18px;
    background:#1f2937;
    color:white;
}
.btn{
    width:100%;
    padding:14px;
    border:none;
    background:#2563eb;
    color:white;
    border-radius:10px;
    cursor:pointer;
    font-size:16px;
    margin-top:10px;
}
.msg-success{
    background:#065f46;
    color:#ecfdf5;
    padding:12px;
    border-radius:10px;
    margin-bottom:20px;
    text-align:center;
    font-weight:bold;
}
@media(max-width:600px){
    .page-box{
        margin-left:0;
        width:94%;
        margin:auto;
        margin-top:20px;
        padding:20px;
    }
    
    .input-text{
    width:94%;
    padding:12px;
    border-radius:10px;
    border:none;
    margin-bottom:18px;
    background:#1f2937;
    color:white;
}
}
</style>

<div class="page-box">

<h2 style="color:white; margin-bottom:20px;">📢 Editar Aviso Inicial da Loja</h2>

<?php if ($msg): ?>
<div class="msg-success" id="msgBox"><?= $msg ?></div>
<?php endif; ?>

<form method="POST" action="save_aviso.php">

    <div class="section-title">Configuração</div>

    <label class="label">Ativar Aviso?</label>
    <select name="enabled" class="input-text">
        <option value="1" <?= $alert["enabled"] ? "selected" : "" ?>>Sim</option>
        <option value="0" <?= !$alert["enabled"] ? "selected" : "" ?>>Não</option>
    </select>

    <label class="label">Título:</label>
    <input class="input-text" name="title" value="<?= $alert['title'] ?>">

    <label class="label">Texto da Mensagem:</label>
    <textarea class="input-text" name="text" rows="4"><?= $alert['text'] ?></textarea>

    <label class="label">Texto do Botão Confirmar:</label>
    <input class="input-text" name="confirm_text" value="<?= $alert['confirm_text'] ?>">

    <label class="label">Texto do Botão Fechar:</label>
    <input class="input-text" name="cancel_text" value="<?= $alert['cancel_text'] ?>">

    <label class="label">Link do Botão:</label>
    <input class="input-text" name="link" value="<?= $alert['link'] ?>">

    <label class="label">URL da Imagem:</label>
    <input class="input-text" name="image_url" value="<?= $alert['image_url'] ?>">

    <label class="label">Largura da Imagem:</label>
    <input class="input-text" name="image_width" value="<?= $alert['image_width'] ?>">

    <label class="label">Altura da Imagem:</label>
    <input class="input-text" name="image_height" value="<?= $alert['image_height'] ?>">

    <button class="btn">Salvar Alterações</button>

</form>

</div>

<script>
setTimeout(()=>{
    let msg=document.getElementById("msgBox");
    if(msg){
        msg.style.opacity="0";
        msg.style.transition=".4s";
        setTimeout(()=>msg.remove(),400);
    }
},1500);
</script>
