<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
header("Content-Type: application/json");

if (!isset($_SESSION['user'])) {
    echo json_encode(["ok"=>false, "msg"=>"Sem permissão"]);
    exit;
}

if (!isset($_GET['id'])) {
    echo json_encode(["ok"=>false, "msg"=>"ID ausente"]);
    exit;
}

$id = intval($_GET['id']);

require_once __DIR__ . "/db.php";

/* Verifica se o APP existe */
$stmt = $db->prepare("SELECT id FROM apps WHERE id = ?");
$stmt->execute([$id]);
$app = $stmt->fetch();

if (!$app) {
    echo json_encode(["ok"=>false, "msg"=>"Aplicativo não encontrado"]);
    exit;
}

/* Gerar código novo */
$code = substr(strtoupper(bin2hex(random_bytes(3))), 0, 6); 
// Ex: A3F91C

/* Salvar na tabela codigo_apk */
$stmt = $db->prepare("
    INSERT INTO codigo_apk (app_id, codigo) 
    VALUES (?, ?)
");
$stmt->execute([$id, $code]);

echo json_encode([
    "ok"   => true,
    "code" => $code
]);
exit;
