<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();

if (!isset($_SESSION['user'])) {
    header("Location: ../adm/login.php");
    exit;
}

// Logo sempre atualizada
$basePath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
$logoUrl  = $basePath . '/logo/logo.png?' . time();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Painel ADM Store</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
/* ===== GLOBAL ===== */
body{
    margin:0;
    background:#0f172a;
    color:#e5e7eb;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* ===== SIDEBAR MODERNA ===== */
.sidebar{
    position:fixed;
    top:0;
    left:0;
    width:240px;
    height:100%;
    background:#0f172a;
    border-right:1px solid #334155;
    padding:20px 0;
    display:flex;
    flex-direction:column;
    align-items:center;
    z-index:5000;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar .logo-box{
    text-align:center;
    margin-bottom:30px;
    padding:0 20px;
}

.sidebar .logo-box img{
    width:80px;
    height:80px;
    object-fit:cover;
    border-radius:16px;
    border:2px solid #3b82f6;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

/* CONTAINER DOS LINKS - CENTRALIZADO */
.sidebar-links{
    width:100%;
    display:flex;
    flex-direction:column;
    align-items:center;
    padding:0 15px;
}

/* CAIXAS DOS ITENS */
.sidebar-item{
    width:100%;
    max-width:200px;
    margin-bottom:8px;
    border-radius:12px;
    overflow:hidden;
    transition: all 0.3s ease;
}

.sidebar-item:hover{
    transform: translateX(5px);
}

.sidebar-item a{
    display:flex;
    align-items:center;
    gap:12px;
    padding:14px 16px;
    text-decoration:none;
    color:#e2e8f0;
    background: rgba(30, 41, 59, 0.6);
    border-left: 3px solid transparent;
    transition: all 0.3s ease;
    width:100%;
}

.sidebar-item a:hover{
    background: rgba(30, 41, 59, 0.9);
    border-left: 3px solid #3b82f6;
    color:#ffffff;
}

.sidebar-item a.active{
    background: rgba(30, 41, 59, 0.9);
    border-left: 3px solid #3b82f6;
    color:#60a5fa;
}

.sidebar-item i{
    font-size:16px;
    width:20px;
    text-align:center;
}

/* SEPARADOR ENTRE SEÇÕES */
.sidebar-divider{
    width:80%;
    height:1px;
    background: linear-gradient(90deg, transparent, #334155, transparent);
    margin:15px auto;
}

/* ITEM DE SAIR DIFERENCIADO */
.sidebar-item.exit{
    margin-top:auto;
    margin-bottom:20px;
}

.sidebar-item.exit a{
    background: rgba(220, 38, 38, 0.1);
    color:#f87171;
    border-left: 3px solid #dc2626;
}

.sidebar-item.exit a:hover{
    background: rgba(220, 38, 38, 0.2);
    color:#fca5a5;
}

/* ===== OVERLAY MOBILE ===== */
.sidebar-overlay{
    display:none;
    position:fixed;
    top:0;
    left:0;
    width:100%;
    height:100%;
    background:rgba(0,0,0,0.7);
    z-index:4000;
}

.sidebar-overlay.show{
    display:block;
}

/* ===== TOPBAR ===== */
.topbar{
    width:calc(100% - 240px);
    position:fixed;
    top:0;
    left:240px;
    height:65px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    padding:0 25px;
    background:#111827;
    border-bottom:1px solid #334155;
    z-index:3000;
    transition:0.3s;
}

.topbar strong{
    font-size:18px;
    font-weight:600;
    background: linear-gradient(135deg, #60a5fa, #a78bfa);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.menu-toggle i{
    color:white;
    font-size:24px;
    padding:10px;
    background:#1e293b;
    border-radius:8px;
    cursor:pointer;
    margin-right: 35px;
}

.menu-toggle:hover{
    background:#334155;
    transform: scale(1.05);
}

.menu-toggle i{
    color:white;
    font-size:20px;
}

/* ===== CONTENT ===== */
.main-content{
    margin-left:240px;
    padding-top:85px;
    min-height:100vh;
    background:#0f172a;
}

.main-wrapper{
    padding:30px;
}

/* ===== MOBILE ===== */
@media(max-width:768px){
    .sidebar{
        left:-240px;
        transition:0.3s ease;
    }
    .sidebar.show{
        left:0;
    }

    .topbar{
        left:0;
        width:100%;
        padding:0 20px;
    }

    .main-content{
        margin-left:0;
    }



/* ANIMAÇÃO SUAVE */
* {
    transition: all 0.2s ease;
}
</style>
</head>
<body>

<!-- ===== SIDEBAR ===== -->
<div class="sidebar" id="sidebar">
    <div class="logo-box">
        <img src="<?= $logoUrl ?>" alt="Logo">
    </div>

    <div class="sidebar-links">
        <div class="sidebar-item">
            <a href="gerenciar.php" class="active">
                <i class="fab fa-android"></i>
                <span>Meus Aplicativos</span>
            </a>
        </div>

        <div class="sidebar-item">
            <a href="personalizar.php">
                <i class="fas fa-paint-brush"></i>
                <span>Personalizar Visual</span>
            </a>
        </div>

        <div class="sidebar-item">
            <a href="editar_aviso.php">
                <i class="fa-brands fa-telegram"></i>
                <span>Editar Mensagem Telegram</span>
            </a>
        </div>
        
        <div class="sidebar-item">
            <a href="editar_whatsapp.php">
                <i class="fab fa-whatsapp"></i>
                <span>Editar Mensagem Whats</span>
            </a>
        </div>
        
        <div class="sidebar-item">
            <a href="contador.php">
                <i class="fas fa-database"></i>
                <span>Contador de Downloads</span>
            </a>
        </div>

        <div class="sidebar-item">
            <a href="logo.php">
                <i class="fas fa-image"></i>
                <span>Editar Logo</span>
            </a>
        </div>

        <div class="sidebar-item">
            <a href="profile.php">
                <i class="fas fa-user-cog"></i>
                <span>Profile</span>
            </a>
        </div>

        <div class="sidebar-divider"></div>

        <div class="sidebar-item">
            <a href="index.php">
                <i class="fas fa-store"></i>
                <span>Ver Loja</span>
            </a>
        </div>

        <div class="sidebar-item exit">
            <a href="logout.php">
                <i class="fas fa-sign-out-alt"></i>
                <span>Sair</span>
            </a>
        </div>
        <div class="sidebar-divider"></div>
        
       <div class="sidebar-item">
    <a href="https://t.me/eonbry" target="_blank"style= "color:yellow";>
        <i class="fa-brands fa-telegram"></i>
        <span style= "color: yellow";>DEV: eonbryjcf</span>
    </a>
</div>


    </div>
</div>



<div class="sidebar-overlay" id="sidebarOverlay"></div>


<!-- ===== TOPBAR ===== -->
<div class="topbar">
    <strong>Painel ADM Store</strong>

    <div class="menu-toggle" id="menuToggle">
        <i class="fas fa-bars"></i>
    </div>
</div>

<!-- ===== CONTENT WRAPPER ===== -->
<div class="main-content">
<div class="main-wrapper">

<script>
const toggle  = document.getElementById("menuToggle");
const sidebar = document.getElementById("sidebar");
const overlay = document.getElementById("sidebarOverlay");

toggle.onclick = () => {
    if (window.innerWidth <= 768) {
        sidebar.classList.toggle("show");
        overlay.classList.toggle("show");

        const icon = toggle.querySelector("i");
        if (sidebar.classList.contains("show")) {
            icon.classList.replace("fa-bars", "fa-times");
        } else {
            icon.classList.replace("fa-times", "fa-bars");
        }
    }
};

overlay.onclick = () => {
    sidebar.classList.remove("show");
    overlay.classList.remove("show");
    toggle.querySelector("i").classList.replace("fa-times", "fa-bars");
};

// Ativar link atual automaticamente
const currentPage = window.location.pathname.split('/').pop();
document.querySelectorAll('.sidebar-item a').forEach(link => {
    if (link.getAttribute('href') === currentPage) {
        link.classList.add('active');
    } else {
        link.classList.remove('active');
    }
});
</script>
