<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xx ------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();

if (!isset($_SESSION['user'])) {
    header("Location: adm/login.php");
    exit;
}

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {

    $arquivo = $_FILES['logo'];

    if ($arquivo['error'] === 0) {

        $ext = strtolower(pathinfo($arquivo['name'], PATHINFO_EXTENSION));

        if (!in_array($ext, ['png','jpg','jpeg'])) {
            $msg = "Formato inválido. Envie PNG ou JPG.";
        } else {

            $destino = __DIR__ . '/logo/logo.png';

            if ($ext === 'jpg' || $ext === 'jpeg') {
                $imagem = imagecreatefromjpeg($arquivo['tmp_name']);
                imagepng($imagem, $destino, 9);
                imagedestroy($imagem);
            } else {
                move_uploaded_file($arquivo['tmp_name'], $destino);
            }

            $msg = "Logo alterada com sucesso!";
        }
    } else {
        $msg = "Erro ao fazer upload da imagem.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<title>Alterar Logo</title>
<link rel="stylesheet" href="assets/admin.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
.page-box{
    background:#111827cc;
    padding:35px;
    border-radius:16px;
    width:100%;
    max-width:900px;       /* container mais largo */
    margin-left:-400px;     /* aproxima da sidebar */
    margin-right:auto;
    box-shadow:0 0 25px rgba(0,0,0,0.4);
    backdrop-filter:blur(12px);
    border:1px solid rgba(255,255,255,0.20);
    box-sizing:border-box;
}

.page-box h2{
    margin-bottom:20px;
    font-size:22px;
    color:#fff;
}

.label-upload{
    color:#cbd5e1;
    font-size:15px;
    margin-bottom:8px;
    display:block;
}

.input-file{
    background:#1f2937;
    border:1px solid #374151;
    padding:12px;
    width:95%;
    border-radius:10px;
    color:white;
}

.btn-modern{
    margin-top:15px;
    background:#2563eb;
    border:none;
    padding:12px 18px;
    font-size:16px;
    border-radius:10px;
    cursor:pointer;
    transition:.2s;
    width:100%;
    color:white;
}

.btn-modern:hover{
    background:#1e40af;
}

.msg-success{
    background:#065f46;
    color:#ecfdf5;
    padding:10px 15px;
    border-radius:8px;
    margin-bottom:15px;
    font-weight:600;
}

.logo-preview{
    margin-top:20px;
    border:1px solid #374151;
    border-radius:12px;
    padding:12px;
    background:#1f2937;
}
@media(max-width:600px){
    .page-box{
        max-width:450px;
        width:600px;
        margin-left:-70px;   /* centralizado */
        padding:22px;
        box-shadow:none;
        border-radius:12px;
    }

    .input-file{
        width:94%;                 /* arruma input */
    }
}
</style>
</head>

<body>

<?php include 'includes/header.php'; ?>

<div class="main-content">
<div class="main-wrapper">

<div class="page-box">
    <h2><i class="fa-solid fa-image"></i> Alterar Logo</h2>

    <?php if($msg): ?>
        <div class="msg-success"><?= $msg ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">

        <label class="label-upload">Selecione a nova logo:</label>
        <input class="input-file" type="file" name="logo" required>

        <button class="btn-modern" type="submit">
            <i class="fa-solid fa-upload"></i> Enviar Nova Logo
        </button>
    </form>

    <div class="logo-preview">
        <h3 style="color:#fff;">Logo atual:</h3>
        <img src="logo/logo.png?<?= time() ?>" style="max-width:200px; display:block; margin-top:10px;">

    </div>

</div>

</div>
</div>

</body>
</html>
