<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) { header("Location: adm/login.php"); exit; }

$stylePath = __DIR__ . "/config/style.json";

if (!file_exists($stylePath)) {
    file_put_contents($stylePath, json_encode([], JSON_PRETTY_PRINT));
}

$style = json_decode(file_get_contents($stylePath), true) ?: [];

function val($k, $default="#000000"){
    global $style;
    return $style[$k] ?? $default;
}

$msg = isset($_GET['ok']) ? "Salvo com sucesso!" : "";
?>

<?php include 'includes/header.php'; ?>

<style>
.page-box{
    background:#111827cc;
    padding:30px;
    border-radius:16px;
    max-width:900px;
    margin-left:260px;
    margin-top:20px;
    box-shadow:0 0 25px rgba(0,0,0,.40);
    border:1px solid rgba(255,255,255,0.25);
    backdrop-filter:blur(12px);
}

.section-title{
    color:#fff;
    font-size:18px;
    margin:20px 0 10px;
    border-left:4px solid #3b82f6;
    padding-left:10px;
}

.label{
    color:#cbd5e1;
    margin-bottom:6px;
    display:block;
    font-size:15px;
}

.color-input{
    width:100%;
    padding:8px;
    border-radius:10px;
    border:none;
    background:#1f2937;
    margin-bottom:18px;
    height:45px;
}

.input-text{
    width:98%;
    padding:12px;
    border-radius:10px;
    border:none;
    margin-bottom:18px;
    background:#1f2937;
    color:white;
}

.btn{
    width:100%;
    padding:14px;
    border:none;
    background:#2563eb;
    color:white;
    border-radius:10px;
    cursor:pointer;
    font-size:16px;
    margin-top:10px;
}

.msg-success{
    background:#065f46;
    color:#ecfdf5;
    padding:12px;
    border-radius:10px;
    margin-bottom:20px;
    text-align:center;
    font-weight:bold;
}

@media(max-width:600px){
    .page-box{
        margin-left:0;
        width:94%;
        margin:auto;
        margin-top:20px;
        padding:20px;
    }

    .input-text{
        width:95%;
    }
}
</style>

<div class="page-box">

<h2 style="color:white; margin-bottom:20px;">🎨 Personalização da Loja</h2>

<?php if ($msg): ?>
<div class="msg-success" id="msgBox"><?= $msg ?></div>
<?php endif; ?>

<form method="POST" action="save_style.php" enctype="multipart/form-data">

    <!-- ======================= LOGO ======================= -->
    <div class="section-title">Logo da Loja</div>

    <label class="label">Logo Atual:</label>
    <img src="<?= $style['logo'] ?? 'logo_loja/logo.png' ?>" 
         style="width:180px; margin-bottom:15px; border-radius:10px; background:#000;" />

    <label class="label">Enviar Nova Logo (PNG/JPG):</label>
    <input type="file" class="input-text" name="logo_upload">

    <label class="label">Ou URL da Logo:</label>
    <input type="text" class="input-text" name="logo_link" placeholder="https://...">


    <!-- ======================= TITULOS ======================= -->
    <div class="section-title">Títulos</div>

    <label class="label">Título da Página:</label>
    <input class="input-text" name="titulo_loja" value="<?= val('titulo_loja','Loja de Aplicativos') ?>">

    <label class="label">Título do Cabeçalho:</label>
    <input class="input-text" name="titulo_header" value="<?= val('titulo_header','Loja de Aplicativos') ?>">

    <label class="label">Fonte Geral:</label>
    <input class="input-text" name="fonte_geral" value="<?= val('fonte_geral','Arial, sans-serif') ?>">

    <label class="label">Tamanho dos Títulos (px):</label>
    <input class="input-text" name="fonte_titulo" value="<?= val('fonte_titulo','22') ?>">

    <label class="label">Tamanho da Descrição (px):</label>
    <input class="input-text" name="fonte_desc" value="<?= val('fonte_desc','15') ?>">


    <!-- ======================= FUNDO ======================= -->
    <div class="section-title">Fundo da Página</div>

    <label class="label">Cor de Fundo da Página:</label>
    <input type="color" class="color-input" name="cor_fundo_pagina" value="<?= val('cor_fundo_pagina','#0f172a') ?>">

    <label class="label">Cor do Título da Página:</label>
    <input type="color" class="color-input" name="cor_titulo_pagina" value="<?= val('cor_titulo_pagina','#ffffff') ?>">


    <!-- ======================= CARDS ======================= -->
    <div class="section-title">Cards / Aplicativos</div>

    <label class="label">Fundo dos Cards:</label>
    <input type="color" class="color-input" name="cor_card_fundo" value="<?= val('cor_card_fundo','#111827') ?>">

    <label class="label">Sombra dos Cards:</label>
    <input type="color" class="color-input" name="cor_card_sombra" value="<?= val('cor_card_sombra','#000000') ?>">

    <label class="label">Título do App:</label>
    <input type="color" class="color-input" name="cor_card_titulo" value="<?= val('cor_card_titulo','#ffffff') ?>">

    <label class="label">Descrição do App:</label>
    <input type="color" class="color-input" name="cor_card_descricao" value="<?= val('cor_card_descricao','#cccccc') ?>">


    <!-- ======================= CAIXA DE CODIGO ======================= -->
    <div class="section-title">Caixa de Códigos</div>

    <label class="label">Fundo da Caixa:</label>
    <input type="color" class="color-input" name="cor_codigo_fundo" value="<?= val('cor_codigo_fundo','#1f2937') ?>">

    <label class="label">Texto Normal:</label>
    <input type="color" class="color-input" name="cor_codigo_texto" value="<?= val('cor_codigo_texto','#ffffff') ?>">

    <label class="label">Texto em Destaque (strong):</label>
    <input type="color" class="color-input" name="cor_codigo_strong" value="<?= val('cor_codigo_strong','#3b82f6') ?>">


    <!-- ======================= BOTOES ======================= -->
    <div class="section-title">Botões</div>

    <label class="label">Texto dos Botões:</label>
    <input type="color" class="color-input" name="btn_texto" value="<?= val('btn_texto','#ffffff') ?>">

    <label class="label">Fundo do Botão "Baixar APK":</label>
    <input type="color" class="color-input" name="btn_download_bg" value="<?= val('btn_download_bg','#2563eb') ?>">

    <label class="label">Hover do Botão "Baixar APK":</label>
    <input type="color" class="color-input" name="btn_download_hover" value="<?= val('btn_download_hover','#1d4ed8') ?>">

    <label class="label">Fundo do Botão "Compartilhar":</label>
    <input type="color" class="color-input" name="btn_share_bg" value="<?= val('btn_share_bg','#4b5563') ?>">

    <label class="label">Hover do Botão "Compartilhar":</label>
    <input type="color" class="color-input" name="btn_share_hover" value="<?= val('btn_share_hover','#374151') ?>">

    <label class="label">Fundo do Botão "Copiar Dados":</label>
    <input type="color" class="color-input" name="btn_copiar_bg" value="<?= val('btn_copiar_bg','#16a34a') ?>">

    <label class="label">Hover do Botão "Copiar Dados":</label>
    <input type="color" class="color-input" name="btn_copiar_hover" value="<?= val('btn_copiar_hover','#15803d') ?>">


    <!-- ======================= ALERTAS ======================= -->
    <div class="section-title">SweetAlert / Alertas</div>

    <label class="label">Botão de Confirmação:</label>
    <input type="color" class="color-input" name="alert_confirmar" value="<?= val('alert_confirmar','#2563eb') ?>">

    <label class="label">Botão "Entrar no Canal":</label>
    <input type="color" class="color-input" name="alert_entrar_canal" value="<?= val('alert_entrar_canal','#10b981') ?>">

    <label class="label">Botão Fechar:</label>
    <input type="color" class="color-input" name="alert_fechar" value="<?= val('alert_fechar','#ef4444') ?>">

    <label class="label">Fundo do Alert:</label>
    <input type="color" class="color-input" name="alert_fundo" value="<?= val('alert_fundo','#1f2937') ?>">

    <label class="label">Texto do Alert:</label>
    <input type="color" class="color-input" name="alert_texto" value="<?= val('alert_texto','#ffffff') ?>">

    <button class="btn">Salvar Alterações</button>
</form>

</div>

<script>
setTimeout(()=>{
    let msg = document.getElementById("msgBox");
    if(msg){
        msg.style.opacity = "0";
        msg.style.transition = ".4s";
        setTimeout(()=> msg.remove(), 400);
    }
}, 1500);
</script>
