<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) {
    header("Location: adm/login.php");
    exit;
}

require_once __DIR__ . "/db.php";

$msg = "";
$erro = "";

/* pega o user atual */
$stmt = $db->prepare("SELECT * FROM users WHERE username = ?");
$stmt->execute([$_SESSION['user']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

/* atualizar */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $novoUser  = trim($_POST['username']);
    $novaSenha = trim($_POST['senha']);

    if ($novoUser == "") {
        $erro = "O usuário é obrigatório.";
    }

    if (!$erro) {

        // atualiza nome
        $stmt = $db->prepare("UPDATE users SET username = ? WHERE id = ?");
        $stmt->execute([$novoUser, $user['id']]);

        // atualiza senha se enviada
        if ($novaSenha != "") {
            $hash = password_hash($novaSenha, PASSWORD_DEFAULT);
            $stmt = $db->prepare("UPDATE users SET pass = ? WHERE id = ?");
            $stmt->execute([$hash, $user['id']]);
        }

        $_SESSION['user'] = $novoUser;
        $msg = "Atualizado!";
    }
}
?>

<?php include 'includes/header.php'; ?>

<style>
.box{
    background:#111827cc;
    padding:30px;
    border-radius:16px;
    width:900px;
    max-width:900px;
    margin-left:130px;
    border:1px solid rgba(255,255,255,0.25);
    box-shadow:0 0 15px rgba(0,0,0,.4);
}

.label{
    color:#cbd5e1; 
    margin-bottom:6px; 
    display:block;
    
}

.input{
    width:96%; 
    padding:12px; 
    background:#1f2937; 
    color:white;
    border:none; 
    border-radius:10px; 
    margin-bottom:18px;
}

.btn{
    width:100%; 
    padding:14px;
    border:none; 
    border-radius:10px;
    background:#2563eb; 
    color:white; 
    cursor:pointer;
}

.btn:hover{ 
    background:#1e40af; 
    
}

.msg-success, .msg-error{
    padding:10px; 
    border-radius:8px; 
    margin-bottom:15px; 
    text-align:center;
}

.msg-success{ 
    background:#065f46; 
    color:#ecfdf5; 
    
}

.msg-error{ 
    background:#7f1d1d; 
    color:#fee2e2; 
    
}

/* mobile */
@media(max-width:600px){
    .box{ 
        margin:10px auto; 
        max-width:90%; 
        padding:22px; 
        
    }
    
    .input{
    width:94%; 
    padding:12px; 
    background:#1f2937; 
    color:white;
    border:none; 
    border-radius:10px; 
    margin-bottom:18px;
}

.box{
    background:#111827cc;
    padding:30px;
    border-radius:16px;
    width:400px;
    max-width:600px;
    margin-left:-50px;
    border:1px solid rgba(255,255,255,0.25);
    box-shadow:0 0 15px rgba(0,0,0,.4);
}
}
</style>

<div class="main-content">
<div class="main-wrapper">

<div class="box">

    <h2 style="color:white; text-align:center; margin-bottom:20px;">
        <i class="fa-solid fa-user"></i> Editar Perfil
    </h2>

    <?php if ($msg): ?><div class="msg-success"><?= $msg ?></div><?php endif; ?>
    <?php if ($erro): ?><div class="msg-error"><?= $erro ?></div><?php endif; ?>

    <form method="POST">

        <label class="label">Usuário:</label>
        <input type="text" class="input" name="username" value="<?= htmlspecialchars($user['username']) ?>">

        <label class="label">Senha (opcional):</label>
        <input type="password" class="input" name="senha" placeholder="Deixe vazio para manter">

        <button class="btn">Salvar</button>
    </form>

</div>

</div>
</div>

<script>
// some sozinho
setTimeout(() => {
    document.querySelectorAll('.msg-success, .msg-error').forEach(el => {
        el.style.transition = "0.4s";
        el.style.opacity = "0";
        setTimeout(() => el.remove(), 500);
    });
}, 2500);
</script>
