/* =====================================================
      VERSÃO DEMÔNIO — NADA ESCAPA
   ===================================================== */

/* 1 — Mata a página se abrir offline */
if (location.protocol === "file:") {
    document.documentElement.innerHTML = "";
    throw new Error();
}

/* 2 — Anti DevTools Mortal */
(function devtoolsKill() {
    const bait = new Image();
    Object.defineProperty(bait, "id", {
        get: function () {
            document.body.innerHTML = "";
            setTimeout(() => location.href = "about:blank", 10);
        }
    });
    console.log(bait);

    setInterval(() => {
        if (
            window.outerWidth - window.innerWidth > 200 ||
            window.outerHeight - window.innerHeight > 200
        ) {
            document.documentElement.innerHTML = "";
            setTimeout(() => location.href = "about:blank", 10);
        }
    }, 300);
})();

/* 3 — Anti-debug que destrói o DOM */
setInterval(() => {
    const start = performance.now();
    debugger;
    if (performance.now() - start > 200) {
        document.documentElement.innerHTML = "";
        location.href = "about:blank";
    }
}, 400);

/* 4 — Travar PrintScreen */
document.addEventListener("keydown", e => {
    if (e.key.includes("PrintScreen")) {
        navigator.clipboard.writeText("");
        alert("Ação bloqueada!");
    }
});

/* 5 — Bloquear salvar página (até PDF) */
document.addEventListener("keydown", e => {
    if (
        (e.ctrlKey && e.key.toLowerCase() === "s") ||
        (e.ctrlKey && e.shiftKey && e.key.toLowerCase() === "p") // print pdf
    ) {
        e.preventDefault();
        alert("Ação bloqueada!");
        return false;
    }
});

/* 6 — Bloquear tudo do DevTools */
document.addEventListener("keydown", e => {
    const k = e.key.toLowerCase();
    if (
        k === "f12" ||
        (e.ctrlKey && k === "u") ||
        (e.ctrlKey && e.shiftKey && ["i","c","j"].includes(k))
    ) {
        e.preventDefault();
        alert("Ação bloqueada!");
        return false;
    }
});

/* 7 — Anti screenshot (alteração brusca de pixels) */
setInterval(() => {
    html2canvas(document.body).then(canvas => {
        const pixels = canvas.getContext("2d").getImageData(0, 0, 50, 50).data;
        let sum = 0;
        for (let i = 0; i < pixels.length; i++) sum += pixels[i];

        if (sum === 0) {
            document.body.innerHTML = "";
            location.href = "about:blank";
        }
    }).catch(() => {});
}, 3000);

/* 8 — Desabilitar copiar / colar / recortar */
["copy", "cut", "paste"].forEach(evt =>
    document.addEventListener(evt, e => e.preventDefault())
);

/* 9 — Bloquear botão direito */
document.addEventListener("contextmenu", e => e.preventDefault());

/* 10 — Bloquear seleção */
document.addEventListener("selectstart", e => e.preventDefault());

/* 11 — Bloquear arrastar (salvar imagens) */
document.addEventListener("dragstart", e => e.preventDefault());

/* 12 — Blindar imagens */
setInterval(() => {
    document.querySelectorAll("img").forEach(img => {
        img.setAttribute("draggable", "false");
        img.style.pointerEvents = "none";
    });
}, 500);

/* 13 — Anti HTTrack, Wget e raspadores */
if (
    navigator.userAgent.includes("HTTrack") ||
    navigator.userAgent.includes("Wget") ||
    navigator.userAgent.includes("curl") ||
    navigator.userAgent.includes("python")
) {
    document.documentElement.innerHTML = "";
}

/* 14 — Quebra se abrir em iframe (anti clonagem) */
if (window !== window.top) {
    document.documentElement.innerHTML = "";
    throw new Error();
}

/* 15 — Anti-Freezing (quando a aba congela) */
let lastTime = performance.now();
setInterval(() => {
    let now = performance.now();
    if (now - lastTime > 1500) {
        document.documentElement.innerHTML = "";
        location.href = "about:blank";
    }
    lastTime = now;
}, 500);
