<?php

//<----------------------------------------------------------->
//<-------------------COPIA AI BRUXÃO------------------------->
//<-------------CONTATO: https://t.me/xxx------------------>
//<-------------DEVELOPER: ----------------->
//<----------------------------------------------------------->


session_start();
if (!isset($_SESSION['user'])) { 
    exit("Sem permissão"); 
}

/* Caminho do JSON */
$stylePath = __DIR__ . "/config/style.json";

/* Carregar dados atuais */
$style = file_exists($stylePath)
    ? json_decode(file_get_contents($stylePath), true)
    : [];

/* ===============================
   FUNÇÃO PARA SALVAR CAMPO
=============================== */
function setVal(&$arr, $key){
    if (isset($_POST[$key])) {
        $arr[$key] = trim($_POST[$key]);
    }
}

/* ===============================
   1) CAMPOS DE TEXTO E CORES
=============================== */
$campos = [
    // Títulos
    "titulo_loja", "titulo_header",

    // Fontes
    "fonte_geral", "fonte_titulo", "fonte_desc",

    // Fundo
    "cor_fundo_pagina", "cor_titulo_pagina",

    // Cards
    "cor_card_fundo", "cor_card_sombra",
    "cor_card_titulo", "cor_card_descricao",

    // Caixa de códigos
    "cor_codigo_fundo", "cor_codigo_texto", "cor_codigo_strong",

    // Botões
    "btn_texto",
    "btn_download_bg", "btn_download_hover",
    "btn_share_bg", "btn_share_hover",
    "btn_copiar_bg", "btn_copiar_hover",

    // Alertas
    "alert_confirmar", "alert_entrar_canal",
    "alert_fechar", "alert_fundo", "alert_texto"
];

foreach ($campos as $c) {
    setVal($style, $c);
}

/* ===============================
   2) LOGO DA LOJA
=============================== */

$logoDir = __DIR__ . "/logo_loja/";
$logoFile = $logoDir . "logo.png";

/* Criar pasta se não existir */
if (!is_dir($logoDir)) {
    mkdir($logoDir, 0777, true);
}

/* LOGO VIA LINK */
if (!empty($_POST["logo_link"])) {
    $style["logo"] = trim($_POST["logo_link"]);
}

/* LOGO VIA UPLOAD */
if (isset($_FILES["logo_upload"]) && $_FILES["logo_upload"]["error"] === 0) {

    $ext = strtolower(pathinfo($_FILES["logo_upload"]["name"], PATHINFO_EXTENSION));

    if (in_array($ext, ["png", "jpg", "jpeg", "gif"])) {

        // Sempre salvar como logo.png
        move_uploaded_file($_FILES["logo_upload"]["tmp_name"], $logoFile);

        // Caminho salvo no JSON
        $style["logo"] = "logo_loja/logo.png";
    }
}

/* ===============================
   3) SALVAR JSON
=============================== */
file_put_contents(
    $stylePath,
    json_encode($style, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)
);

/* Redirecionar */
header("Location: personalizar.php?ok=1");
exit;
