<?php
require_once __DIR__ . '/includes/auth.php';
require_once __DIR__ . '/includes/functions.php';
require_login();

$message = '';
$messageType = 'success';
$currentUser = $_SESSION['pp_user'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $csrf = $_POST['csrf'] ?? '';

  if (!csrf_check($csrf)) {
    $message = 'Session expired. Please refresh.';
    $messageType = 'error';
  } else {

    $currentPass = $_POST['current_password'] ?? '';
    $newUser  = trim($_POST['new_username'] ?? '');
    $newPass  = $_POST['new_password'] ?? '';
    $newPass2 = $_POST['new_password2'] ?? '';

    if ($newUser === '' || $newPass === '') {
      $message = 'Username and password cannot be empty.';
      $messageType = 'error';
    } elseif ($newPass !== $newPass2) {
      $message = 'Passwords do not match.';
      $messageType = 'error';
    } elseif (!verify_user($currentUser, $currentPass)) {
      $message = 'Current password is incorrect.';
      $messageType = 'error';
    } else {

      $hash = password_hash($newPass, PASSWORD_DEFAULT);
      $users = [[
        'username'      => $newUser,
        'password_hash'=> $hash,
        'updated_at'   => date('c')
      ]];

      if (file_put_contents(USERS_JSON_PATH, json_encode($users, JSON_PRETTY_PRINT))) {
        $_SESSION['pp_user'] = $newUser;
        $message = 'Login details updated successfully.';
        $messageType = 'success';
      } else {
        $message = 'Failed to update users.json';
        $messageType = 'error';
      }
    }
  }
}

$title = 'Security';
$active = 'security';
include __DIR__ . '/includes/header.php';
?>

<div class="row justify-content-center">
  <div class="col-12 col-md-11 col-lg-10 col-xl-9">

    <div class="card"
         style="background:#0f0f1a;border-radius:20px;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">

        <h5 class="mb-4">
          <i class="fa fa-lock"></i> Security
        </h5>

        <?php if ($message): ?>
          <div class="alert alert-<?= $messageType === 'success' ? 'success' : 'danger' ?> py-2">
            <?= htmlspecialchars($message) ?>
          </div>
        <?php endif; ?>

        <form method="post">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

          <div class="row">

            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">Current password</label>
                <input class="form-control"
                       type="password"
                       name="current_password"
                       required>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">New username</label>
                <input class="form-control"
                       name="new_username"
                       value="<?= htmlspecialchars($currentUser) ?>"
                       required>
              </div>
            </div>

          </div>

          <div class="row">

            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">New password</label>
                <input class="form-control"
                       type="password"
                       name="new_password"
                       required>
              </div>
            </div>

            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">Repeat new password</label>
                <input class="form-control"
                       type="password"
                       name="new_password2"
                       required>
              </div>
            </div>

          </div>

          <div class="text-right mt-3">
            <button class="btn btn-primary">
              <i class="fa fa-save"></i> Update login
            </button>
          </div>

        </form>

      </div>
    </div>

  </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
