<!-- index.php -->
<?php 
include ('includes/header.php');


//table name
$table_name = "leaguesx";
$page = "hot_sports.php";
$pagekey = "sport_api.php";

$sp_api = $db->select('spapi', '*', 'id = :id', '', [':id' => 1]);

$mykey = !empty($sp_api[0]['apikey']) ? $sp_api[0]['apikey'] : '';


if($mykey === ''){
    echo "<script>window.location.href='".$pagekey."'</script>";
}


$json_url = "https://www.thesportsdb.com/api/v1/json/$mykey/all_leagues.php";
$json_data = file_get_contents($json_url);
$leagues = json_decode($json_data, true);

//table call
$res = $db->select($table_name, '*', '', '');

//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
	unset($_POST['submit']);
	$db->insert($table_name, $_POST);
	$db->close();
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

?>

<?php if (isset($_GET['create'])){?>

<!-- Form Start -->
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Create Hot League ID</h6>
                    <form method="post">
                        <div class="mb-3">
                            <label class="form-label">league</label>
                            <select name="league" id="league" class="form-select mb-3" onchange="updateLeagueId(this)">
                                <?php foreach ($leagues['leagues'] as $league): ?>
                                <option value="<?= htmlspecialchars($league['strLeague']) ?>"
                                    data-idleague="<?= htmlspecialchars($league['idLeague']) ?>"
                                    data-idsport="<?= htmlspecialchars($league['strSport']) ?>"
                                    <?= (isset($updateData['leagueId']) && $updateData['leagueId'] === $league['strLeague']) ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($league['strLeague']) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="leagueId">League ID</label>
                            <input class="form-control" id="leagueId" name="leagueId" placeholder="League ID"
                                type="text" readonly />
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="lsports">Sport</label>
                            <input class="form-control" id="lsports" name="lsports" placeholder="Sport"
                                type="text" readonly />
                        </div>
                        <button type="submit" name="submit" class="btn btn-primary">Save</button>
                    </form>
            </div>
        </div>
    </div>
</div>

<?php }else{?>

<!-- Table Start -->
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <h2 class="mb-4">Hot Leagues</h6>
                    <div class="text-end">
                        <a type="button" href="./<?=$page ?>?create" class="btn btn-square btn-primary m-2"><i
                                class="fa fa-plus"></i></a>
                    </div>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>League name</th>
                                    <th>League ID</th>
                                    <th>Sport</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <?php foreach ($res as $row) {
							?>
                            <tbody>
                                <tr>
                                    <td><?=$row['id']; ?></a></td>
                                    <td><?=$row['league'] ?></a></td>
                                    <td><?=$row['leagueId'] ?></td>
                                    <td><?=$row['lsports'] ?></td>
                                    <td><a class="btn btn-square btn-primary m-2" href="#"
                                            data-href="<?php echo $page; ?>?delete=<?php echo $row['id']; ?>"
                                            data-bs-toggle="modal" data-bs-target="#confirm-delete">
                                            <i class="fa fa-trash"></i>
                                        </a></td>
                                </tr>
                            </tbody>
                            <?php
							}?>
                        </table>
                    </div>


            </div>
        </div>
    </div>
</div>
<!-- Table End -->

<?php }?>
<script>
function updateLeagueId(selectElement) {
    var leagueId = selectElement.options[selectElement.selectedIndex].dataset.idleague;
    var sport = selectElement.options[selectElement.selectedIndex].dataset.idsport;
    document.getElementById('leagueId').value = leagueId;
    document.getElementById('lsports').value = sport;
}

// Call the function on page load to set the initial value
window.onload = function() {
    var selectElement = document.getElementById('leagueId');
    updateLeagueId(selectElement);
};
</script>
<?php include ('includes/footer.php');?>
<!-- Footer End -->
</body>

</html>